/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import java.lang.reflect.Array;

public abstract class DescribePlanar<T extends ImageGray<T>, Desc extends TupleDesc>
implements DescribeRegionPoint<Planar<T>, Desc> {
    DescribeRegionPoint<T, Desc>[] describers;
    int length;
    Class<Desc> descType;
    Desc[] descBand;

    protected DescribePlanar(DescribeRegionPoint<T, Desc>[] describers) {
        this.describers = describers;
        this.descType = describers[0].getDescriptionType();
        this.descBand = (TupleDesc[])Array.newInstance(this.descType, describers.length);
        this.length = 0;
        for (int i = 0; i < describers.length; ++i) {
            this.descBand[i] = describers[i].createDescription();
            this.length += this.descBand[i].size();
        }
    }

    @Override
    public void setImage(Planar<T> image) {
        if (image.getNumBands() != this.describers.length) {
            throw new IllegalArgumentException("Unexpected number of bands in input image.  Found " + image.getNumBands() + " expected " + this.describers.length);
        }
        for (int i = 0; i < this.describers.length; ++i) {
            this.describers[i].setImage(image.getBand(i));
        }
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, Desc description) {
        for (int i = 0; i < this.describers.length; ++i) {
            if (this.describers[i].process(x, y, orientation, radius, this.descBand[i])) continue;
            return false;
        }
        this.combine(description);
        return true;
    }

    protected abstract void combine(Desc var1);

    @Override
    public boolean isScalable() {
        return this.describers[0].isScalable();
    }

    @Override
    public boolean isOriented() {
        return this.describers[0].isOriented();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this.descType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.describers[0].getCanonicalWidth();
    }
}

