/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescriptionSets;
import boofcv.abst.feature.associate.AssociateThreeDescription;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.AssociatedTripleIndex;
import boofcv.struct.feature.MatchScoreType;
import boofcv.struct.feature.TupleDesc;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class AssociateThreeByPairs<Desc extends TupleDesc>
implements AssociateThreeDescription<Desc> {
    protected AssociateDescriptionSets<Desc> associator;
    protected FastAccess<Desc> featuresA;
    protected FastAccess<Desc> featuresB;
    protected FastAccess<Desc> featuresC;
    protected DogArray_I32 setsA;
    protected DogArray_I32 setsB;
    protected DogArray_I32 setsC;
    protected FastArray<Desc> tmpB;
    protected FastArray<Desc> tmpA;
    protected DogArray_I32 tmpSetsA = new DogArray_I32();
    protected DogArray_I32 tmpSetsB = new DogArray_I32();
    protected DogArray<AssociatedTripleIndex> matches = new DogArray<AssociatedTripleIndex>(AssociatedTripleIndex::new);
    protected DogArray_I32 srcToC = new DogArray_I32();

    public AssociateThreeByPairs(AssociateDescription<Desc> associator, Class<Desc> type) {
        if (!associator.uniqueDestination() || !associator.uniqueSource()) {
            throw new IllegalArgumentException("Both source and destination need to be unique");
        }
        this.associator = new AssociateDescriptionSets<Desc>(associator, type);
        this.tmpB = new FastArray<Desc>(type);
        this.tmpA = new FastArray<Desc>(type);
    }

    @Override
    public void initialize(int numberOfSets) {
        this.associator.initialize(numberOfSets);
    }

    @Override
    public void setFeaturesA(FastAccess<Desc> features, DogArray_I32 sets) {
        this.featuresA = features;
        this.setsA = sets;
    }

    @Override
    public void setFeaturesB(FastAccess<Desc> features, DogArray_I32 sets) {
        this.featuresB = features;
        this.setsB = sets;
    }

    @Override
    public void setFeaturesC(FastAccess<Desc> features, DogArray_I32 sets) {
        this.featuresC = features;
        this.setsC = sets;
    }

    @Override
    public void associate() {
        int i;
        this.sanityCheck();
        this.matches.reset();
        UtilFeature.setSource(this.featuresA, this.setsA, this.associator);
        UtilFeature.setDestination(this.featuresB, this.setsB, this.associator);
        this.associator.associate();
        FastAccess<AssociatedIndex> pairs = this.associator.getMatches();
        this.tmpA.resize(pairs.size);
        this.tmpSetsA.resize(pairs.size);
        this.tmpB.resize(pairs.size);
        this.tmpSetsB.resize(pairs.size);
        for (int i2 = 0; i2 < pairs.size; ++i2) {
            AssociatedIndex p = pairs.get(i2);
            this.matches.grow().setTo(p.src, p.dst, -1);
            ((TupleDesc[])this.tmpA.data)[i2] = ((TupleDesc[])this.featuresA.data)[p.src];
            ((TupleDesc[])this.tmpB.data)[i2] = ((TupleDesc[])this.featuresB.data)[p.dst];
            this.tmpSetsA.data[i2] = this.setsA.data[p.src];
            this.tmpSetsB.data[i2] = this.setsB.data[p.dst];
        }
        UtilFeature.setSource(this.tmpB, this.tmpSetsB, this.associator);
        UtilFeature.setDestination(this.featuresC, this.setsC, this.associator);
        this.associator.associate();
        pairs = this.associator.getMatches();
        this.tmpB.resize(pairs.size);
        this.tmpSetsB.resize(pairs.size);
        this.srcToC.resize(pairs.size);
        FastArray<Desc> tmpC = this.tmpB;
        DogArray_I32 tmpSetsC = this.tmpSetsB;
        for (int i3 = 0; i3 < pairs.size; ++i3) {
            AssociatedIndex p = pairs.get(i3);
            ((AssociatedTripleIndex)this.matches.get((int)p.src)).c = p.dst;
            ((TupleDesc[])tmpC.data)[i3] = ((TupleDesc[])this.featuresC.data)[p.dst];
            tmpSetsC.data[i3] = this.setsC.data[p.dst];
            this.srcToC.data[i3] = p.dst;
        }
        DogArray_I32 unsrc = this.associator.getUnassociatedSource();
        for (i = 0; i < unsrc.size; ++i) {
            int idx = unsrc.get(i);
            ((AssociatedTripleIndex)this.matches.get((int)idx)).c = -1;
        }
        UtilFeature.setSource(tmpC, tmpSetsC, this.associator);
        UtilFeature.setDestination(this.tmpA, this.tmpSetsA, this.associator);
        this.associator.associate();
        pairs = this.associator.getMatches();
        for (i = 0; i < pairs.size; ++i) {
            AssociatedIndex p = pairs.get(i);
            AssociatedTripleIndex t = (AssociatedTripleIndex)this.matches.get(p.dst);
            if (((AssociatedTripleIndex)this.matches.get((int)p.dst)).c == this.srcToC.data[p.src]) continue;
            t.c = -1;
        }
        DogArray_I32 undst = this.associator.getUnassociatedDestination();
        for (int i4 = 0; i4 < undst.size; ++i4) {
            int idx = undst.get(i4);
            ((AssociatedTripleIndex)this.matches.get((int)idx)).c = -1;
        }
        this.pruneMatches();
    }

    private void sanityCheck() {
        assert (this.featuresA != this.featuresB);
        assert (this.featuresA != this.featuresC);
        assert (this.featuresB != this.featuresC);
        assert (this.setsA != this.setsB);
        assert (this.setsA != this.setsC);
        assert (this.setsB != this.setsC);
    }

    private void pruneMatches() {
        int index = 0;
        while (index < this.matches.size) {
            AssociatedTripleIndex a = (AssociatedTripleIndex)this.matches.get(index);
            if (a.c == -1) {
                a.setTo((AssociatedTripleIndex)this.matches.get(this.matches.size - 1));
                --this.matches.size;
                continue;
            }
            ++index;
        }
    }

    @Override
    public DogArray<AssociatedTripleIndex> getMatches() {
        return this.matches;
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.associator.setMaxScoreThreshold(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.associator.getScoreType();
    }

    @Override
    public boolean isEachFeatureAssociatedOnlyOnce() {
        return true;
    }
}

