/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.spherical.EquirectangularTools_F32;
import boofcv.struct.distort.PixelTransform;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.EulerType;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public abstract class EquirectangularDistortBase_F32
implements PixelTransform<Point2D_F32> {
    EquirectangularTools_F32 tools = new EquirectangularTools_F32();
    int outWidth;
    FMatrixRMaj R = CommonOps_FDRM.identity(3, 3);
    Vector3D_F32 n = new Vector3D_F32();
    Point3D_F32[] vectors = new Point3D_F32[0];

    public void setEquirectangularShape(int width, int height) {
        this.tools.configure(width, height);
    }

    public void setConcurrent(EquirectangularDistortBase_F32 original) {
        this.outWidth = original.outWidth;
        this.R.set(original.R);
        this.n.setTo(original.n);
        this.tools = original.tools;
        this.vectors = original.vectors;
    }

    public void setDirection(float yaw, float pitch, float roll) {
        ConvertRotation3D_F32.eulerToMatrix(EulerType.YZX, pitch, yaw, roll, this.R);
    }

    public void setDirection(FMatrixRMaj R) {
        this.R.set(R);
    }

    protected void declareVectors(int width, int height) {
        this.outWidth = width;
        if (this.vectors.length < width * height) {
            Point3D_F32[] tmp = new Point3D_F32[width * height];
            System.arraycopy(this.vectors, 0, tmp, 0, this.vectors.length);
            for (int i = this.vectors.length; i < tmp.length; ++i) {
                tmp[i] = new Point3D_F32();
            }
            this.vectors = tmp;
        }
    }

    @Override
    public void compute(int x, int y, Point2D_F32 out) {
        Point3D_F32 v = this.vectors[y * this.outWidth + x];
        GeometryMath_F32.mult(this.R, v, this.n);
        this.tools.normToEquiFV(this.n.x, this.n.y, this.n.z, out);
    }

    public EquirectangularTools_F32 getTools() {
        return this.tools;
    }

    public FMatrixRMaj getRotation() {
        return this.R;
    }
}

