/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point3Transform2_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class NarrowToWidePtoP_F32
implements Point2Transform2_F32 {
    FMatrixRMaj rotateWideToNarrow = CommonOps_FDRM.identity(3, 3);
    Point2Transform2_F32 narrowToNorm;
    Point3Transform2_F32 unitToWide;
    Point2D_F32 norm = new Point2D_F32();
    Point3D_F32 unit = new Point3D_F32();

    public NarrowToWidePtoP_F32() {
    }

    public NarrowToWidePtoP_F32(LensDistortionNarrowFOV narrow, LensDistortionWideFOV wide) {
        this.configure(narrow, wide);
    }

    public void configure(LensDistortionNarrowFOV narrow, LensDistortionWideFOV wide) {
        this.narrowToNorm = narrow.undistort_F32(true, false);
        this.unitToWide = wide.distortStoP_F32();
    }

    public void setRotationWideToNarrow(FMatrixRMaj R) {
        this.rotateWideToNarrow.set(R);
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        this.narrowToNorm.compute(x, y, this.norm);
        this.unit.setTo(this.norm.x, this.norm.y, 1.0f);
        GeometryMath_F32.mult(this.rotateWideToNarrow, this.unit, this.unit);
        float n = this.unit.norm();
        this.unit.x /= n;
        this.unit.y /= n;
        this.unit.z /= n;
        this.unitToWide.compute(this.unit.x, this.unit.y, this.unit.z, out);
    }

    @Override
    public Point2Transform2_F32 copyConcurrent() {
        NarrowToWidePtoP_F32 ret = new NarrowToWidePtoP_F32();
        ret.rotateWideToNarrow = this.rotateWideToNarrow.copy();
        ret.narrowToNorm = this.narrowToNorm.copyConcurrent();
        ret.unitToWide = this.unitToWide.copyConcurrent();
        return ret;
    }
}

