/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import georegression.geometry.UtilPoint2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;

public class LensDistortionOps_F32 {
    public static <O extends CameraPinhole, D extends CameraPinhole> Point2Transform2_F32 transformChangeModel(AdjustmentType type, O paramOriginal, D paramDesired, boolean desiredToOriginal, D paramMod) {
        RectangleLength2D_F32 bound;
        LensDistortionNarrowFOV original = LensDistortionFactory.narrow(paramOriginal);
        LensDistortionNarrowFOV desired = LensDistortionFactory.narrow(paramDesired);
        Point2Transform2_F32 ori_p_to_n = original.undistort_F32(true, false);
        Point2Transform2_F32 des_n_to_p = desired.distort_F32(false, true);
        SequencePoint2Transform2_F32 ori_to_des = new SequencePoint2Transform2_F32(ori_p_to_n, des_n_to_p);
        Point2D_F32 work = new Point2D_F32();
        if (type == AdjustmentType.FULL_VIEW) {
            bound = DistortImageOps.boundBox_F32(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F32(ori_to_des), work);
        } else if (type == AdjustmentType.EXPAND) {
            bound = LensDistortionOps_F32.boundBoxInside(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F32(ori_to_des), work);
            LensDistortionOps_F32.roundInside(bound);
        } else if (type == AdjustmentType.CENTER) {
            bound = LensDistortionOps_F32.centerBoxInside(paramOriginal.width, paramOriginal.height, new PointToPixelTransform_F32(ori_to_des), work);
        } else if (type == AdjustmentType.NONE) {
            bound = new RectangleLength2D_F32(0.0f, 0.0f, paramDesired.width, paramDesired.height);
        } else {
            throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
        }
        float scaleX = bound.width / (float)paramDesired.width;
        float scaleY = bound.height / (float)paramDesired.height;
        float scale = type == AdjustmentType.FULL_VIEW ? Math.max(scaleX, scaleY) : (type == AdjustmentType.EXPAND ? Math.min(scaleX, scaleY) : (type == AdjustmentType.CENTER ? Math.max(scaleX, scaleY) : 1.0f));
        float deltaX = bound.x0 + (scaleX - scale) * (float)paramDesired.width / 2.0f;
        float deltaY = bound.y0 + (scaleY - scale) * (float)paramDesired.height / 2.0f;
        FMatrixRMaj A2 = new FMatrixRMaj(3, 3, true, scale, 0.0f, deltaX, 0.0f, scale, deltaY, 0.0f, 0.0f, 1.0f);
        FMatrixRMaj A_inv = new FMatrixRMaj(3, 3);
        if (!CommonOps_FDRM.invert(A2, A_inv)) {
            throw new RuntimeException("Failed to invert adjustment matrix.  Probably bad.");
        }
        if (paramMod != null) {
            PerspectiveOps.adjustIntrinsic(paramDesired, A_inv, paramMod);
        }
        if (desiredToOriginal) {
            Point2Transform2_F32 des_p_to_n = desired.undistort_F32(true, false);
            Point2Transform2_F32 ori_n_to_p = original.distort_F32(false, true);
            PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A2);
            return new SequencePoint2Transform2_F32(adjust, des_p_to_n, ori_n_to_p);
        }
        PointTransformHomography_F32 adjust = new PointTransformHomography_F32(A_inv);
        return new SequencePoint2Transform2_F32(ori_to_des, adjust);
    }

    public static RectangleLength2D_F32 boundBoxInside(int srcWidth, int srcHeight, PixelTransform<Point2D_F32> transform, Point2D_F32 work) {
        List<Point2D_F32> points = LensDistortionOps_F32.computeBoundingPoints(srcWidth, srcHeight, transform, work);
        Point2D_F32 center = new Point2D_F32();
        UtilPoint2D_F32.mean(points, center);
        float y0 = Float.MAX_VALUE;
        float x0 = Float.MAX_VALUE;
        float y1 = -3.4028235E38f;
        float x1 = -3.4028235E38f;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            if (p.x < x0) {
                x0 = p.x;
            }
            if (p.x > x1) {
                x1 = p.x;
            }
            if (p.y < y0) {
                y0 = p.y;
            }
            if (!(p.y > y1)) continue;
            y1 = p.y;
        }
        float ox0 = x0 -= center.x;
        float oy0 = y0 -= center.y;
        float ox1 = x1 -= center.x;
        float oy1 = y1 -= center.y;
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F32 p = points.get(i);
            float dx = p.x - center.x;
            float dy = p.y - center.y;
            if (!(dx > x0) || !(dy > y0) || !(dx < x1) || !(dy < y1)) continue;
            float d0 = Math.abs(dx - x0) + x0 - ox0;
            float d1 = Math.abs(dx - x1) + ox1 - x1;
            float d2 = Math.abs(dy - y0) + y0 - oy0;
            float d3 = Math.abs(dy - y1) + oy1 - y1;
            if (d0 <= d1 && d0 <= d2 && d0 <= d3) {
                x0 = dx;
                continue;
            }
            if (d1 <= d2 && d1 <= d3) {
                x1 = dx;
                continue;
            }
            if (d2 <= d3) {
                y0 = dy;
                continue;
            }
            y1 = dy;
        }
        return new RectangleLength2D_F32(x0 + center.x, y0 + center.y, x1 - x0, y1 - y0);
    }

    public static RectangleLength2D_F32 centerBoxInside(int srcWidth, int srcHeight, PixelTransform<Point2D_F32> transform, Point2D_F32 work) {
        List<Point2D_F32> points = LensDistortionOps_F32.computeBoundingPoints(srcWidth, srcHeight, transform, work);
        Point2D_F32 center = new Point2D_F32();
        UtilPoint2D_F32.mean(points, center);
        float y1 = 0.0f;
        float y0 = 0.0f;
        float x1 = 0.0f;
        float x0 = 0.0f;
        float by1 = Float.MAX_VALUE;
        float by0 = Float.MAX_VALUE;
        float bx1 = Float.MAX_VALUE;
        float bx0 = Float.MAX_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            float ady;
            Point2D_F32 p = points.get(i);
            float dx = p.x - center.x;
            float dy = p.y - center.y;
            float adx = Math.abs(dx);
            if (adx < (ady = Math.abs(dy))) {
                if (dy < 0.0f) {
                    if (!(adx < by0)) continue;
                    by0 = adx;
                    y0 = dy;
                    continue;
                }
                if (!(adx < by1)) continue;
                by1 = adx;
                y1 = dy;
                continue;
            }
            if (dx < 0.0f) {
                if (!(ady < bx0)) continue;
                bx0 = ady;
                x0 = dx;
                continue;
            }
            if (!(ady < bx1)) continue;
            bx1 = ady;
            x1 = dx;
        }
        return new RectangleLength2D_F32(x0 + center.x, y0 + center.y, x1 - x0, y1 - y0);
    }

    private static List<Point2D_F32> computeBoundingPoints(int srcWidth, int srcHeight, PixelTransform<Point2D_F32> transform, Point2D_F32 work) {
        ArrayList<Point2D_F32> points = new ArrayList<Point2D_F32>();
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0, work);
            points.add(new Point2D_F32(work.x, work.y));
            transform.compute(x, srcHeight, work);
            points.add(new Point2D_F32(work.x, work.y));
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y, work);
            points.add(new Point2D_F32(work.x, work.y));
            transform.compute(srcWidth, y, work);
            points.add(new Point2D_F32(work.x, work.y));
        }
        return points;
    }

    public static void roundInside(RectangleLength2D_F32 bound) {
        float x0 = (float)Math.ceil(bound.x0);
        float y0 = (float)Math.ceil(bound.y0);
        float x1 = (float)Math.floor(bound.x0 + bound.width);
        float y1 = (float)Math.floor(bound.y0 + bound.height);
        bound.x0 = x0;
        bound.y0 = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }
}

