/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.sgm;

import boofcv.alg.disparity.sgm.SgmCostAggregation;
import boofcv.alg.disparity.sgm.SgmDisparityCost;
import boofcv.alg.disparity.sgm.SgmDisparitySelector;
import boofcv.alg.disparity.sgm.SgmHelper;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.Planar;

public abstract class SgmStereoDisparity<T extends ImageBase<T>, C extends ImageBase<C>> {
    protected int disparityMin = 0;
    protected int disparityRange = 0;
    protected SgmDisparityCost<C> sgmCost;
    protected SgmCostAggregation aggregation = new SgmCostAggregation();
    protected SgmDisparitySelector selector;
    protected SgmHelper helper = new SgmHelper();
    protected Planar<GrayU16> costYXD = new Planar<GrayU16>(GrayU16.class, 1, 1, 1);
    protected GrayU8 disparity = new GrayU8(1, 1);

    protected SgmStereoDisparity(SgmDisparityCost<C> sgmCost, SgmDisparitySelector selector) {
        this.sgmCost = sgmCost;
        this.selector = selector;
    }

    public abstract void process(T var1, T var2);

    public void subpixel(GrayU8 src, GrayF32 dst) {
        dst.reshape(src);
        Planar<GrayU16> aggregatedYXD = this.aggregation.getAggregated();
        for (int y = 0; y < aggregatedYXD.getNumBands(); ++y) {
            int x;
            GrayU16 costXD = aggregatedYXD.getBand(y);
            for (x = 0; x < this.disparityMin; ++x) {
                dst.unsafe_set(x, y, this.disparityRange);
            }
            for (x = this.disparityMin; x < costXD.height; ++x) {
                float subpixel;
                int localMaxRange = this.helper.localDisparityRangeLeft(x);
                int d = src.unsafe_get(x, y);
                if (d > 0 && d < localMaxRange - 1) {
                    int adjX = x - this.disparityMin;
                    int c0 = costXD.unsafe_get(d - 1, adjX);
                    int c1 = costXD.unsafe_get(d, adjX);
                    int c2 = costXD.unsafe_get(d + 1, adjX);
                    float offset = (float)(c0 - c2) / (float)(2 * (c0 - 2 * c1 + c2));
                    subpixel = (float)d + offset;
                } else {
                    subpixel = d;
                }
                dst.unsafe_set(x, y, subpixel);
            }
        }
    }

    public GrayU8 getDisparity() {
        return this.disparity;
    }

    public SgmDisparityCost<C> getSgmCost() {
        return this.sgmCost;
    }

    public SgmCostAggregation getAggregation() {
        return this.aggregation;
    }

    public Planar<GrayU16> getCostYXD() {
        return this.costYXD;
    }

    public int getInvalidDisparity() {
        return this.selector.getInvalidDisparity();
    }

    public int getDisparityMin() {
        return this.disparityMin;
    }

    public void setDisparityMin(int disparityMin) {
        this.disparityMin = disparityMin;
    }

    public int getDisparityRange() {
        return this.disparityRange;
    }

    public void setDisparityRange(int disparityRange) {
        this.disparityRange = disparityRange;
    }

    public SgmDisparitySelector getSelector() {
        return this.selector;
    }
}

