/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.block.select.SelectCorrelationWithChecks_F32;
import boofcv.struct.image.GrayF32;

public class SelectCorrelationSubpixel {

    public static class F32_F32
    extends SelectCorrelationWithChecks_F32<GrayF32> {
        public F32_F32(int rightToLeftTolerance, double texture) {
            super(rightToLeftTolerance, texture, GrayF32.class);
        }

        F32_F32(F32_F32 original) {
            super(original);
        }

        @Override
        protected void setDisparity(int index, int disparityValue) {
            if (disparityValue <= 0 || disparityValue >= this.localRange - 1) {
                ((GrayF32)this.imageDisparity).data[index] = disparityValue;
            } else {
                float c0 = this.columnScore[disparityValue - 1];
                float c1 = this.columnScore[disparityValue];
                float c2 = this.columnScore[disparityValue + 1];
                float offset = (c0 - c2) / (2.0f * (c0 - 2.0f * c1 + c2));
                ((GrayF32)this.imageDisparity).data[index] = (float)disparityValue + offset;
            }
        }

        @Override
        protected void setDisparityInvalid(int index) {
            ((GrayF32)this.imageDisparity).data[index] = (byte)this.invalidDisparity;
        }

        @Override
        public DisparitySelect<float[], GrayF32> concurrentCopy() {
            return new F32_F32(this);
        }

        @Override
        public Class<GrayF32> getDisparityType() {
            return GrayF32.class;
        }
    }
}

