/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.score;

import boofcv.alg.disparity.DisparityBlockMatch;
import boofcv.alg.disparity.block.BlockRowScore;
import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import pabeles.concurrency.GrowArray;
import pabeles.concurrency.IntRangeObjectConsumer;

public class DisparityScoreBM_F32<DI extends ImageGray<DI>>
extends DisparityBlockMatch<GrayF32, DI> {
    DisparitySelect<float[], DI> disparitySelect0;
    BlockRowScore<GrayF32, float[], float[]> scoreRows;
    GrayF32 left;
    GrayF32 right;
    DI disparity;
    GrowArray<WorkSpace> workspace = new GrowArray<WorkSpace>(() -> new WorkSpace());
    ComputeBlock computeBlock = new ComputeBlock();

    public DisparityScoreBM_F32(int regionRadiusX, int regionRadiusY, BlockRowScore<GrayF32, float[], float[]> scoreRows, DisparitySelect<float[], DI> computeDisparity) {
        super(regionRadiusX, regionRadiusY, ImageType.SB_F32);
        this.scoreRows = scoreRows;
        this.disparitySelect0 = computeDisparity;
        this.workspace.grow();
    }

    @Override
    public void setBorder(ImageBorder<GrayF32> border) {
        super.setBorder(border);
        this.scoreRows.setBorder(border);
    }

    @Override
    public void _process(GrayF32 left, GrayF32 right, DI disparity) {
        this.left = left;
        this.right = right;
        this.disparity = disparity;
        this.growBorderL.setImage(left);
        this.growBorderR.setImage(right);
        this.scoreRows.setInput(left, right);
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.loopBlocks(0, left.height, this.regionHeight, this.workspace, this.computeBlock);
        } else {
            this.computeBlock.accept(this.workspace.get(0), 0, left.height);
        }
    }

    private void computeFirstRow(int row0, WorkSpace ws) {
        for (int row = 0; row < this.regionHeight; ++row) {
            this.growBorderL.growRow(row0 + row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row0 + row, this.radiusX, this.radiusX, ws.rightRow, 0);
            float[] scores = ws.horizontalScore[row];
            this.scoreRows.scoreRow(row0 + row, ws.leftRow, ws.rightRow, scores, this.disparityMin, this.disparityMax, this.regionWidth, ws.elementScore);
        }
        for (int i = 0; i < this.widthDisparityBlock; ++i) {
            float sum = 0.0f;
            for (int row = 0; row < this.regionHeight; ++row) {
                sum += ws.horizontalScore[row][i];
            }
            ws.verticalScore[i] = sum;
        }
        if (this.scoreRows.isRequireNormalize()) {
            this.scoreRows.normalizeRegionScores(row0 + this.radiusY, ws.verticalScore, this.disparityMin, this.disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm);
            ws.computeDisparity.process(row0 + this.radiusY, ws.verticalScoreNorm);
        } else {
            ws.computeDisparity.process(row0 + this.radiusY, ws.verticalScore);
        }
    }

    private void computeRemainingRows(int row0, int row1, WorkSpace ws) {
        for (int row = row0 + this.regionHeight; row < row1; ++row) {
            int i;
            int oldRow = (row - row0) % this.regionHeight;
            float[] scores = ws.horizontalScore[oldRow];
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                ws.verticalScore[n] = ws.verticalScore[n] - scores[i];
            }
            this.growBorderL.growRow(row, this.radiusX, this.radiusX, ws.leftRow, 0);
            this.growBorderR.growRow(row, this.radiusX, this.radiusX, ws.rightRow, 0);
            this.scoreRows.scoreRow(row, ws.leftRow, ws.rightRow, scores, this.disparityMin, this.disparityMax, this.regionWidth, ws.elementScore);
            for (i = 0; i < this.widthDisparityBlock; ++i) {
                int n = i;
                ws.verticalScore[n] = ws.verticalScore[n] + scores[i];
            }
            if (this.scoreRows.isRequireNormalize()) {
                this.scoreRows.normalizeRegionScores(row - this.regionHeight + 1 + this.radiusY, ws.verticalScore, this.disparityMin, this.disparityMax, this.regionWidth, this.regionHeight, ws.verticalScoreNorm);
                ws.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, ws.verticalScoreNorm);
                continue;
            }
            ws.computeDisparity.process(row - this.regionHeight + 1 + this.radiusY, ws.verticalScore);
        }
    }

    @Override
    public ImageType<GrayF32> getInputType() {
        return ImageType.SB_F32;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.disparitySelect0.getDisparityType();
    }

    @Override
    protected int getMaxPerPixelError() {
        return this.scoreRows.getMaxPerPixelError();
    }

    public void setDisparitySelect0(DisparitySelect<float[], DI> disparitySelect0) {
        this.disparitySelect0 = disparitySelect0;
    }

    class WorkSpace {
        float[] elementScore;
        float[][] horizontalScore = new float[0][0];
        float[] verticalScore = new float[0];
        float[] verticalScoreNorm = new float[0];
        float[] leftRow;
        float[] rightRow;
        DisparitySelect<float[], DI> computeDisparity;

        WorkSpace() {
        }

        public void checkSize() {
            if (this.horizontalScore.length != DisparityScoreBM_F32.this.regionHeight || this.horizontalScore[0].length != DisparityScoreBM_F32.this.widthDisparityBlock) {
                this.horizontalScore = new float[DisparityScoreBM_F32.this.regionHeight][DisparityScoreBM_F32.this.widthDisparityBlock];
                this.verticalScore = new float[DisparityScoreBM_F32.this.widthDisparityBlock];
                if (DisparityScoreBM_F32.this.scoreRows.isRequireNormalize()) {
                    this.verticalScoreNorm = new float[DisparityScoreBM_F32.this.widthDisparityBlock];
                }
                this.elementScore = new float[DisparityScoreBM_F32.this.left.width + 2 * DisparityScoreBM_F32.this.radiusX];
                this.leftRow = (float[])DisparityScoreBM_F32.this.left.getImageType().getDataType().newArray(this.elementScore.length);
                this.rightRow = (float[])DisparityScoreBM_F32.this.right.getImageType().getDataType().newArray(this.elementScore.length);
            }
            if (this.computeDisparity == null) {
                this.computeDisparity = DisparityScoreBM_F32.this.disparitySelect0.concurrentCopy();
            }
            this.computeDisparity.configure(DisparityScoreBM_F32.this.disparity, DisparityScoreBM_F32.this.disparityMin, DisparityScoreBM_F32.this.disparityMax, DisparityScoreBM_F32.this.radiusX);
        }
    }

    private class ComputeBlock
    implements IntRangeObjectConsumer<WorkSpace> {
        private ComputeBlock() {
        }

        @Override
        public void accept(WorkSpace workspace, int minInclusive, int maxExclusive) {
            workspace.checkSize();
            int row0 = minInclusive - DisparityScoreBM_F32.this.radiusY;
            int row1 = maxExclusive + DisparityScoreBM_F32.this.radiusY;
            DisparityScoreBM_F32.this.computeFirstRow(row0, workspace);
            DisparityScoreBM_F32.this.computeRemainingRows(row0, row1, workspace);
        }
    }
}

