/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.impl.ImplColorXyz;
import boofcv.alg.color.impl.ImplColorXyz_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorXyz {
    public static final float[] table_invgamma_f = new float[256];
    public static final double[] table_invgamma_d = new double[256];

    public static void rgbToXyz(int r, int g, int b, double[] xyz) {
        ColorXyz.linearRgbToXyz(ColorXyz.invGamma((double)r / 255.0), ColorXyz.invGamma((double)g / 255.0), ColorXyz.invGamma((double)b / 255.0), xyz);
    }

    public static void rgbToXyz(int r, int g, int b, float[] xyz) {
        ColorXyz.linearRgbToXyz((float)ColorXyz.invGamma((float)r / 255.0f), (float)ColorXyz.invGamma((float)g / 255.0f), (float)ColorXyz.invGamma((float)b / 255.0f), xyz);
    }

    public static void rgbToXyz(double r, double g, double b, float[] xyz) {
        ColorXyz.linearRgbToXyz((float)ColorXyz.invGamma(r / 255.0), (float)ColorXyz.invGamma(g / 255.0), (float)ColorXyz.invGamma(b / 255.0), xyz);
    }

    public static void xyzToRgb(double x, double y, double z, double[] linearRgb, int[] rgb) {
        ColorXyz.xyzToLinearRgb(x, y, z, linearRgb);
        rgb[0] = (int)(255.0 * ColorXyz.gamma(linearRgb[0]) + 0.5) & 0xFF;
        rgb[1] = (int)(255.0 * ColorXyz.gamma(linearRgb[1]) + 0.5) & 0xFF;
        rgb[2] = (int)(255.0 * ColorXyz.gamma(linearRgb[2]) + 0.5) & 0xFF;
    }

    public static void xyzToRgb(float x, float y, float z, float[] linearRgb, int[] rgb) {
        ColorXyz.xyzToLinearRgb(x, y, z, linearRgb);
        rgb[0] = (int)(255.0 * ColorXyz.gamma(linearRgb[0]) + 0.5) & 0xFF;
        rgb[1] = (int)(255.0 * ColorXyz.gamma(linearRgb[1]) + 0.5) & 0xFF;
        rgb[2] = (int)(255.0 * ColorXyz.gamma(linearRgb[2]) + 0.5) & 0xFF;
    }

    public static void xyzToRgb(float x, float y, float z, float[] linearRgb, float[] rgb) {
        ColorXyz.xyzToLinearRgb(x, y, z, linearRgb);
        rgb[0] = (float)(255.0 * ColorXyz.gamma(linearRgb[0]));
        rgb[1] = (float)(255.0 * ColorXyz.gamma(linearRgb[1]));
        rgb[2] = (float)(255.0 * ColorXyz.gamma(linearRgb[2]));
    }

    public static double invGamma(double v) {
        if (v <= 0.04045) {
            return v / 12.92;
        }
        return Math.pow((v + 0.055) / 1.055, 2.4);
    }

    public static double gamma(double v) {
        if (v <= 0.0031308) {
            return 12.92 * v;
        }
        return 1.055 * Math.pow(v, 0.4166666666666667) - 0.055;
    }

    public static void linearRgbToXyz(double r, double g, double b, double[] xyz) {
        xyz[0] = 0.412453 * r + 0.35758 * g + 0.180423 * b;
        xyz[1] = 0.212671 * r + 0.71516 * g + 0.072169 * b;
        xyz[2] = 0.019334 * r + 0.119193 * g + 0.950227 * b;
    }

    public static void linearRgbToXyz(float r, float g, float b, float[] xyz) {
        xyz[0] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
        xyz[1] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
        xyz[2] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
    }

    public static void xyzToLinearRgb(float x, float y, float z, float[] linearRgb) {
        linearRgb[0] = 3.240479f * x - 1.53715f * y - 0.498535f * z;
        linearRgb[1] = -0.969256f * x + 1.875991f * y + 0.041556f * z;
        linearRgb[2] = 0.055648f * x - 0.204043f * y + 1.057311f * z;
    }

    public static void xyzToLinearRgb(double x, double y, double z, double[] linearRgb) {
        linearRgb[0] = 3.240479 * x - 1.53715 * y - 0.498535 * z;
        linearRgb[1] = -0.969256 * x + 1.875991 * y + 0.041556 * z;
        linearRgb[2] = 0.055648 * x - 0.204043 * y + 1.057311 * z;
    }

    public static <T extends ImageGray<T>> void rgbToXyz(Planar<T> rgb, Planar<GrayF32> xyz) {
        xyz.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.rgbToXyz_U8(rgb, xyz);
            } else {
                ImplColorXyz.rgbToXyz_U8(rgb, xyz);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.rgbToXyz_F32(rgb, xyz);
            } else {
                ImplColorXyz.rgbToXyz_F32(rgb, xyz);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void xyzToRgb(Planar<GrayF32> xyz, Planar<T> rgb) {
        xyz.reshape(rgb.width, rgb.height, 3);
        if (rgb.getBandType() == GrayU8.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.xyzToRgb_U8(xyz, rgb);
            } else {
                ImplColorXyz.xyzToRgb_U8(xyz, rgb);
            }
        } else if (rgb.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorXyz_MT.xyzToRgb_F32(xyz, rgb);
            } else {
                ImplColorXyz.xyzToRgb_F32(xyz, rgb);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + rgb.getBandType().getSimpleName());
        }
    }

    static {
        for (int i = 0; i < table_invgamma_f.length; ++i) {
            ColorXyz.table_invgamma_d[i] = ColorXyz.invGamma((double)i / 255.0);
            ColorXyz.table_invgamma_f[i] = (float)table_invgamma_d[i];
        }
    }
}

