/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.tracker.dda.DetectDescribeAssociateTracker;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PointTrackerDda<I extends ImageGray<I>, TD extends TupleDesc>
implements PointTracker<I> {
    DetectDescribeAssociateTracker<I, TD> tracker;

    public PointTrackerDda(DetectDescribeAssociateTracker<I, TD> tracker) {
        this.tracker = tracker;
    }

    @Override
    public void process(I image) {
        this.tracker.process(image);
    }

    @Override
    public void reset() {
        this.tracker.reset();
    }

    @Override
    public long getFrameID() {
        return this.tracker.getFrameID();
    }

    @Override
    public int getTotalActive() {
        return this.tracker.getTracksActive().size();
    }

    @Override
    public int getTotalInactive() {
        return this.tracker.getTracksInactive().size();
    }

    @Override
    public void dropAllTracks() {
        this.tracker.dropAllTracks();
    }

    @Override
    public int getMaxSpawn() {
        return 0;
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        return this.tracker.dropTrack(track);
    }

    @Override
    public void dropTracks(PointTracker.Dropper dropper) {
        this.tracker.dropTracks(dropper);
    }

    @Override
    public void spawnTracks() {
        this.tracker.spawnTracks();
    }

    @Override
    public List<PointTrack> getActiveTracks(@Nullable List<PointTrack> list) {
        return PointTrackerDda.addAllTracksInList(this.tracker.getTracksActive(), list);
    }

    @Override
    public List<PointTrack> getDroppedTracks(@Nullable List<PointTrack> list) {
        return PointTrackerDda.addAllTracksInList(this.tracker.getTracksDropped(), list);
    }

    @Override
    public List<PointTrack> getNewTracks(@Nullable List<PointTrack> list) {
        return PointTrackerDda.addAllTracksInList(this.tracker.getTracksNew(), list);
    }

    @Override
    public List<PointTrack> getAllTracks(@Nullable List<PointTrack> list) {
        return PointTrackerDda.addAllTracksInList(this.tracker.getTracksAll().toList(), list);
    }

    @Override
    public List<PointTrack> getInactiveTracks(@Nullable List<PointTrack> list) {
        return PointTrackerDda.addAllTracksInList(this.tracker.getTracksInactive(), list);
    }

    public static List<PointTrack> addAllTracksInList(List<PointTrack> tracks, @Nullable List<PointTrack> output) {
        if (output == null) {
            output = new ArrayList<PointTrack>();
        } else {
            output.clear();
        }
        output.addAll(tracks);
        return output;
    }
}

