/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.RefineTriangulateMetric;
import boofcv.alg.geo.triangulate.ResidualsTriangulateMetricSimple;
import boofcv.misc.BoofMiscOps;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ejml.data.DMatrixRMaj;

public class TriangulateRefineMetricLS
implements RefineTriangulateMetric {
    final ResidualsTriangulateMetricSimple func = new ResidualsTriangulateMetricSimple();
    final UnconstrainedLeastSquares<DMatrixRMaj> minimizer;
    final double[] param = new double[3];
    int maxIterations;
    double convergenceTol;

    public TriangulateRefineMetricLS(double convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, false);
        BoofMiscOps.checkEq(3, this.func.getNumOfInputsN());
    }

    @Override
    public boolean process(List<Point2D_F64> observations, List<Se3_F64> listWorldToView, Point3D_F64 worldPt, Point3D_F64 refinedPt) {
        this.func.setObservations(observations, listWorldToView);
        this.minimizer.setFunction(this.func, null);
        this.param[0] = worldPt.x;
        this.param[1] = worldPt.y;
        this.param[2] = worldPt.z;
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        double[] found = this.minimizer.getParameters();
        refinedPt.x = found[0];
        refinedPt.y = found[1];
        refinedPt.z = found[2];
        return true;
    }

    public ResidualsTriangulateMetricSimple getFunc() {
        return this.func;
    }

    public UnconstrainedLeastSquares<DMatrixRMaj> getMinimizer() {
        return this.minimizer;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getConvergenceTol() {
        return this.convergenceTol;
    }

    public void setConvergenceTol(double convergenceTol) {
        this.convergenceTol = convergenceTol;
    }
}

