/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.selfcalib;

import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.GeometricResult;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.ResolveSignAmbiguityPositiveDepth;
import boofcv.alg.geo.selfcalib.SelfCalibrationLinearDualQuadratic;
import boofcv.alg.geo.structure.DecomposeAbsoluteDualQuadratic;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTuple;
import boofcv.struct.image.ImageDimension;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.struct.FastAccess;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ProjectiveToMetricCameraDualQuadratic
implements ProjectiveToMetricCameras {
    final SelfCalibrationLinearDualQuadratic selfCalib;
    final DecomposeAbsoluteDualQuadratic decomposeDualQuad = new DecomposeAbsoluteDualQuadratic();
    final DMatrixRMaj P1 = CommonOps_DDRM.identity(3, 4);
    final DMatrixRMaj H = new DMatrixRMaj(4, 4);
    final DMatrixRMaj K = new DMatrixRMaj(3, 3);
    final ResolveSignAmbiguityPositiveDepth resolveSign = new ResolveSignAmbiguityPositiveDepth();

    public ProjectiveToMetricCameraDualQuadratic(SelfCalibrationLinearDualQuadratic selfCalib) {
        this.selfCalib = selfCalib;
    }

    @Override
    public boolean process(List<ImageDimension> dimensions, List<DMatrixRMaj> views, List<AssociatedTuple> observations, MetricCameras metricViews) {
        int i;
        BoofMiscOps.checkEq(views.size() + 1, dimensions.size(), "View[0] is implicitly identity and not included");
        metricViews.reset();
        this.selfCalib.reset();
        this.selfCalib.addCameraMatrix(this.P1);
        for (int i2 = 0; i2 < views.size(); ++i2) {
            this.selfCalib.addCameraMatrix(views.get(i2));
        }
        GeometricResult results = this.selfCalib.solve();
        if (results != GeometricResult.SUCCESS) {
            return false;
        }
        if (!this.decomposeDualQuad.decompose(this.selfCalib.getQ())) {
            return false;
        }
        if (!this.decomposeDualQuad.computeRectifyingHomography(this.H)) {
            return false;
        }
        FastAccess<SelfCalibrationLinearDualQuadratic.Intrinsic> solutions = this.selfCalib.getSolutions();
        if (solutions.size != dimensions.size()) {
            return false;
        }
        for (int i3 = 0; i3 < solutions.size; ++i3) {
            solutions.get(i3).copyTo(metricViews.intrinsics.grow());
        }
        double largestT = 0.0;
        for (i = 0; i < views.size(); ++i) {
            DMatrixRMaj P = views.get(i);
            PerspectiveOps.pinholeToMatrix((CameraPinhole)metricViews.intrinsics.get(i + 1), this.K);
            if (!MultiViewOps.projectiveToMetricKnownK(P, this.H, this.K, metricViews.motion_1_to_k.grow())) {
                return false;
            }
            largestT = Math.max(largestT, ((Se3_F64)metricViews.motion_1_to_k.getTail()).T.norm());
        }
        for (i = 0; i < metricViews.motion_1_to_k.size; ++i) {
            ((Se3_F64)metricViews.motion_1_to_k.get((int)i)).T.divide(largestT);
        }
        this.resolveSign.process(observations, metricViews);
        return true;
    }

    @Override
    public int getMinimumViews() {
        return this.selfCalib.getMinimumProjectives();
    }

    public SelfCalibrationLinearDualQuadratic getSelfCalib() {
        return this.selfCalib;
    }
}

