/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.alg.geo.calibration.cameras.Zhang99CameraBrown;
import boofcv.alg.geo.calibration.cameras.Zhang99CameraUniversalOmni;
import boofcv.struct.calib.CameraModel;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class CalibrateMonoPlanar
implements VerbosePrint {
    protected DetectorFiducialCalibration detector;
    protected List<Point2D_F64> layout;
    protected CalibrationPlanarGridZhang99 zhang99;
    protected SceneStructureMetric structure;
    protected CameraModel foundIntrinsic;
    protected List<CalibrationObservation> observations = new ArrayList<CalibrationObservation>();
    protected List<ImageResults> errors;
    public PrintStream verbose = null;
    private int imageWidth;
    private int imageHeight;

    public CalibrateMonoPlanar(List<Point2D_F64> layout) {
        this.layout = layout;
    }

    public void configure(Zhang99Camera camera) {
        this.zhang99 = new CalibrationPlanarGridZhang99(this.layout, camera);
    }

    public void configurePinhole(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        Zhang99CameraBrown camera = new Zhang99CameraBrown(assumeZeroSkew, includeTangential, numRadialParam);
        this.zhang99 = new CalibrationPlanarGridZhang99(this.layout, camera);
    }

    public void configureUniversalOmni(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.zhang99 = new CalibrationPlanarGridZhang99(this.layout, new Zhang99CameraUniversalOmni(assumeZeroSkew, includeTangential, numRadialParam));
    }

    public void configureUniversalOmni(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential, double mirrorOffset) {
        this.zhang99 = new CalibrationPlanarGridZhang99(this.layout, new Zhang99CameraUniversalOmni(assumeZeroSkew, includeTangential, numRadialParam, mirrorOffset));
    }

    public void reset() {
        this.observations = new ArrayList<CalibrationObservation>();
        this.errors = null;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    public void addImage(CalibrationObservation observation) {
        if (this.imageWidth == 0) {
            this.imageWidth = observation.getWidth();
            this.imageHeight = observation.getHeight();
        } else if (observation.getWidth() != this.imageWidth || observation.getHeight() != this.imageHeight) {
            throw new IllegalArgumentException("Image shape miss match");
        }
        this.observations.add(observation);
    }

    public void removeLatestImage() {
        this.observations.remove(this.observations.size() - 1);
    }

    public <T extends CameraModel> T process() {
        if (this.zhang99 == null) {
            throw new IllegalArgumentException("Please call configure first.");
        }
        this.zhang99.setVerbose(this.verbose, null);
        if (!this.zhang99.process(this.observations)) {
            throw new RuntimeException("Zhang99 algorithm failed!");
        }
        this.structure = this.zhang99.getStructure();
        this.errors = this.zhang99.computeErrors();
        this.foundIntrinsic = this.zhang99.getCameraModel();
        this.foundIntrinsic.width = this.imageWidth;
        this.foundIntrinsic.height = this.imageHeight;
        return (T)this.foundIntrinsic;
    }

    public void printStatistics() {
        CalibrateMonoPlanar.printErrors(this.errors);
    }

    public static void printErrors(List<ImageResults> results) {
        double totalError = 0.0;
        for (int i = 0; i < results.size(); ++i) {
            ImageResults r = results.get(i);
            totalError += r.meanError;
            System.out.printf("image %3d Euclidean ( mean = %7.1e max = %7.1e ) bias ( X = %8.1e Y %8.1e )\n", i, r.meanError, r.maxError, r.biasX, r.biasY);
        }
        System.out.println("Average Mean Error = " + totalError / (double)results.size());
    }

    public void setRobust(boolean robust) {
        this.zhang99.setRobust(robust);
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public <T extends CameraModel> T getIntrinsic() {
        return (T)this.foundIntrinsic;
    }

    public CalibrationPlanarGridZhang99 getZhang99() {
        return this.zhang99;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public List<CalibrationObservation> getObservations() {
        return this.observations;
    }

    public List<ImageResults> getErrors() {
        return this.errors;
    }
}

