/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.misc.BoofMiscOps;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class SceneStructureMetric
extends SceneStructureCommon {
    public final DogArray<View> views = new DogArray<View>(View::new, View::reset);
    public final DogArray<Motion> motions = new DogArray<Motion>(Motion::new, Motion::reset);
    public final DogArray<Rigid> rigids = new DogArray<Rigid>(Rigid::new, Rigid::reset);
    public int[] lookupRigid;

    public SceneStructureMetric(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        this.initialize(totalCameras, totalViews, totalViews, totalPoints, 0);
    }

    public void initialize(int totalCameras, int totalViews, int totalMotions, int totalPoints, int totalRigid) {
        this.motions.resize(totalMotions);
        this.cameras.reset();
        this.views.reset();
        this.motions.reset();
        this.points.reset();
        this.rigids.reset();
        this.cameras.resize(totalCameras);
        this.views.resize(totalViews);
        this.points.resize(totalPoints);
        this.rigids.resize(totalRigid);
        this.lookupRigid = null;
    }

    public void assignIDsToRigidPoints() {
        if (this.lookupRigid != null) {
            return;
        }
        this.lookupRigid = new int[this.getTotalRigidPoints()];
        int pointID = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            Rigid r = ((Rigid[])this.rigids.data)[i];
            r.indexFirst = pointID;
            int j = 0;
            while (j < r.points.length) {
                this.lookupRigid[pointID] = i;
                ++j;
                ++pointID;
            }
        }
    }

    public Se3_F64 getParentToView(View view) {
        return ((Motion)this.motions.get((int)view.parent_to_view)).motion;
    }

    public Se3_F64 getParentToView(int viewIdx) {
        View v = (View)this.views.get(viewIdx);
        return ((Motion)this.motions.get((int)v.parent_to_view)).motion;
    }

    public Se3_F64 getWorldToView(View view, @Nullable Se3_F64 world_to_view, @Nullable Se3_F64 tmp) {
        if (world_to_view == null) {
            world_to_view = new Se3_F64();
        }
        if (tmp == null) {
            tmp = new Se3_F64();
        }
        world_to_view.setTo(this.getParentToView(view));
        while (view.parent != null) {
            view = view.parent;
            Se3_F64 parent_to_view = this.getParentToView(view);
            parent_to_view.concat(world_to_view, tmp);
            world_to_view.setTo(tmp);
        }
        return world_to_view;
    }

    public boolean hasRigid() {
        return this.rigids.size > 0;
    }

    public void setView(int viewIndex, int cameraIndex, boolean known, Se3_F64 world_to_view) {
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = this.addMotion(known, world_to_view);
        ((View)this.views.get((int)viewIndex)).parent = null;
    }

    public void setView(int viewIndex, int cameraIndex, boolean known, Se3_F64 parent_to_view, int parent) {
        BoofMiscOps.checkTrue(parent < viewIndex, "Parent must be less than viewIndex");
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = this.addMotion(known, parent_to_view);
        ((View)this.views.get((int)viewIndex)).parent = parent >= 0 ? (View)this.views.get(parent) : null;
    }

    public void setView(int viewIndex, int cameraIndex, int motionIndex, int parent) {
        BoofMiscOps.checkTrue(parent < viewIndex, "Parent must be less than viewIndex");
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
        ((View)this.views.get((int)viewIndex)).parent_to_view = motionIndex;
        ((View)this.views.get((int)viewIndex)).parent = parent >= 0 ? (View)this.views.get(parent) : null;
    }

    public int addMotion(boolean known, Se3_F64 motion) {
        int index = this.motions.size;
        Motion m = this.motions.grow();
        m.known = known;
        m.motion.setTo(motion);
        return index;
    }

    public void setRigid(int which, boolean known, Se3_F64 worldToObject, int totalPoints) {
        Rigid rigid = new Rigid();
        ((Rigid[])this.rigids.data)[which] = rigid;
        Rigid r = rigid;
        r.known = known;
        r.object_to_world.setTo(worldToObject);
        r.points = new SceneStructureCommon.Point[totalPoints];
        for (int i = 0; i < totalPoints; ++i) {
            r.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (((View)this.views.get((int)viewIndex)).camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        ((View)this.views.get((int)viewIndex)).camera = cameraIndex;
    }

    public int getUnknownCameraCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera[])this.cameras.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownMotionCount() {
        int total = 0;
        for (int i = 0; i < this.motions.size; ++i) {
            if (((Motion)this.motions.get((int)i)).known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownRigidCount() {
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            if (((Rigid[])this.rigids.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getTotalRigidPoints() {
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            total += ((Rigid[])this.rigids.data)[i].points.length;
        }
        return total;
    }

    public SceneStructureCommon.Camera getViewCamera(View v) {
        return (SceneStructureCommon.Camera)this.cameras.get(v.camera);
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownMotionCount() * 6 + this.getUnknownRigidCount() * 6 + this.points.size * this.pointSize + this.getUnknownCameraParameterCount();
    }

    public DogArray<View> getViews() {
        return this.views;
    }

    public DogArray<Rigid> getRigids() {
        return this.rigids;
    }

    public boolean isIdentical(SceneStructureMetric m, double tol) {
        int i;
        if (this.isHomogenous() != m.isHomogenous()) {
            return false;
        }
        if (this.views.size != m.views.size) {
            return false;
        }
        if (this.motions.size != m.motions.size) {
            return false;
        }
        if (this.rigids.size != m.rigids.size) {
            return false;
        }
        if (this.cameras.size != m.cameras.size) {
            return false;
        }
        if (this.points.size != m.points.size) {
            return false;
        }
        for (i = 0; i < this.views.size; ++i) {
            if (((View)this.views.get(i)).isIdentical((View)m.views.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.motions.size; ++i) {
            if (((Motion)this.motions.get(i)).isIdentical((Motion)m.motions.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.rigids.size; ++i) {
            if (((Rigid)this.rigids.get(i)).isIdentical((Rigid)m.rigids.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera)this.cameras.get(i)).isIdentical((SceneStructureCommon.Camera)m.cameras.get(i), tol)) continue;
            return false;
        }
        for (i = 0; i < this.points.size; ++i) {
            if (!(((SceneStructureCommon.Point)this.points.get(i)).distance((SceneStructureCommon.Point)m.points.get(i)) > tol)) continue;
            return false;
        }
        return true;
    }

    public static class Rigid {
        public boolean known;
        public final Se3_F64 object_to_world = new Se3_F64();
        public SceneStructureCommon.Point[] points;
        public int indexFirst;

        public void reset() {
            this.known = false;
            this.object_to_world.reset();
            this.points = null;
            this.indexFirst = -1;
        }

        public void setPoint(int which, double x, double y, double z) {
            this.points[which].set(x, y, z);
        }

        public void setPoint(int which, double x, double y, double z, double w) {
            this.points[which].set(x, y, z, w);
        }

        public void getPoint(int which, Point3D_F64 p) {
            this.points[which].get(p);
        }

        public void getPoint(int which, Point4D_F64 p) {
            this.points[which].get(p);
        }

        public int getTotalPoints() {
            return this.points.length;
        }

        public boolean isIdentical(Rigid m, double tol) {
            if (this.known != m.known) {
                return false;
            }
            if (this.indexFirst != m.indexFirst) {
                return false;
            }
            if (this.points != null) {
                if (m.points == null) {
                    return false;
                }
                if (this.points.length != m.points.length) {
                    return false;
                }
                for (int i = 0; i < this.points.length; ++i) {
                    if (!(this.points[i].distance(m.points[i]) > tol)) continue;
                    return false;
                }
            } else {
                return m.points == null;
            }
            return true;
        }
    }

    public static class View {
        public int parent_to_view = -1;
        public int camera = -1;
        @Nullable
        public View parent;

        public void reset() {
            this.parent_to_view = -1;
            this.camera = -1;
            this.parent = null;
        }

        public boolean isIdentical(View m) {
            if (this.parent_to_view != m.parent_to_view) {
                return false;
            }
            if (this.camera != m.camera) {
                return false;
            }
            if (this.parent == null) {
                return m.parent == null;
            }
            return m.parent != null;
        }
    }

    public static class Motion {
        public boolean known;
        public final Se3_F64 motion = new Se3_F64();

        public void reset() {
            this.known = true;
            this.motion.reset();
        }

        public boolean isIdentical(Motion m, double tol) {
            if (this.known != m.known) {
                return false;
            }
            if (this.motion.T.distance((GeoTuple_F64)m.motion.T) > tol) {
                return false;
            }
            for (int i = 0; i < 9; ++i) {
                if (!(Math.abs(this.motion.R.data[i] - m.motion.R.data[i]) > tol)) continue;
                return false;
            }
            return true;
        }
    }
}

