/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.BoofDefaults;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo0;
import boofcv.alg.filter.derivative.GradientTwo1;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public abstract class ImageGradient_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageGradient<Input, Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Input> border;
    Class<Input> inputType;
    Class<Output> derivType;

    protected ImageGradient_SB(Class<Input> inputType, Class<Output> derivType) {
        this.inputType = inputType;
        this.derivType = derivType;
        this.setBorderType(this.borderType);
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        this.border = FactoryImageBorder.single(this.borderType, this.inputType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    @Override
    public ImageType<Input> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<Output> getDerivativeType() {
        return ImageType.single(this.derivType);
    }

    public static class Two1<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageGradient_SB<T, D> {
        public Two1(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivX, D derivY) {
            GradientTwo1.process(inputImage, derivX, derivY, this.border);
        }
    }

    public static class Two0<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageGradient_SB<T, D> {
        public Two0(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivX, D derivY) {
            GradientTwo0.process(inputImage, derivX, derivY, this.border);
        }
    }

    public static class Three<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageGradient_SB<T, D> {
        public Three(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivX, D derivY) {
            GradientThree.process(inputImage, derivX, derivY, this.border);
        }
    }

    public static class Prewitt<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageGradient_SB<T, D> {
        public Prewitt(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivX, D derivY) {
            GradientPrewitt.process(inputImage, derivX, derivY, this.border);
        }
    }

    public static class Sobel<T extends ImageGray<T>, D extends ImageGray<D>>
    extends ImageGradient_SB<T, D> {
        public Sobel(Class<T> inputType, Class<D> derivType) {
            super(inputType, derivType);
        }

        @Override
        public void process(T inputImage, D derivX, D derivY) {
            GradientSobel.process(inputImage, derivX, derivY, this.border);
        }
    }
}

