/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.struct.Configuration;

public class ConfigChessboardX
implements Configuration {
    public int detNonMaxRadius = 1;
    public double detNonMaxThresholdRatio = 0.05;
    public double detRefinedXCornerThreshold = 0.025;
    public int detPyramidTopSize = 100;
    public double connEdgeThreshold = 0.05;
    public double connDirectionTol = 0.85;
    public double connOrientationTol = 0.65;
    public double connAmbiguousTol = 0.25;
    public int connMaxNeighbors = 20;
    public double connMaxNeighborDistance = Double.MAX_VALUE;
    public boolean gridRequireCornerSquares = false;

    public void setTo(ConfigChessboardX src) {
        this.detNonMaxRadius = src.detNonMaxRadius;
        this.detNonMaxThresholdRatio = src.detNonMaxThresholdRatio;
        this.detRefinedXCornerThreshold = src.detRefinedXCornerThreshold;
        this.detPyramidTopSize = src.detPyramidTopSize;
        this.connEdgeThreshold = src.connEdgeThreshold;
        this.connDirectionTol = src.connDirectionTol;
        this.connOrientationTol = src.connOrientationTol;
        this.connAmbiguousTol = src.connAmbiguousTol;
        this.connMaxNeighbors = src.connMaxNeighbors;
        this.connMaxNeighborDistance = src.connMaxNeighborDistance;
        this.gridRequireCornerSquares = src.gridRequireCornerSquares;
    }

    @Override
    public void checkValidity() {
        if (this.connDirectionTol < 0.0 || this.connDirectionTol > 1.0) {
            throw new IllegalArgumentException("directionTol must be 0 to 1");
        }
    }

    public int getDetNonMaxRadius() {
        return this.detNonMaxRadius;
    }

    public double getDetNonMaxThresholdRatio() {
        return this.detNonMaxThresholdRatio;
    }

    public double getDetRefinedXCornerThreshold() {
        return this.detRefinedXCornerThreshold;
    }

    public int getDetPyramidTopSize() {
        return this.detPyramidTopSize;
    }

    public double getConnEdgeThreshold() {
        return this.connEdgeThreshold;
    }

    public double getConnDirectionTol() {
        return this.connDirectionTol;
    }

    public double getConnOrientationTol() {
        return this.connOrientationTol;
    }

    public double getConnAmbiguousTol() {
        return this.connAmbiguousTol;
    }

    public int getConnMaxNeighbors() {
        return this.connMaxNeighbors;
    }

    public double getConnMaxNeighborDistance() {
        return this.connMaxNeighborDistance;
    }

    public boolean isGridRequireCornerSquares() {
        return this.gridRequireCornerSquares;
    }

    public void setDetNonMaxRadius(int detNonMaxRadius) {
        this.detNonMaxRadius = detNonMaxRadius;
    }

    public void setDetNonMaxThresholdRatio(double detNonMaxThresholdRatio) {
        this.detNonMaxThresholdRatio = detNonMaxThresholdRatio;
    }

    public void setDetRefinedXCornerThreshold(double detRefinedXCornerThreshold) {
        this.detRefinedXCornerThreshold = detRefinedXCornerThreshold;
    }

    public void setDetPyramidTopSize(int detPyramidTopSize) {
        this.detPyramidTopSize = detPyramidTopSize;
    }

    public void setConnEdgeThreshold(double connEdgeThreshold) {
        this.connEdgeThreshold = connEdgeThreshold;
    }

    public void setConnDirectionTol(double connDirectionTol) {
        this.connDirectionTol = connDirectionTol;
    }

    public void setConnOrientationTol(double connOrientationTol) {
        this.connOrientationTol = connOrientationTol;
    }

    public void setConnAmbiguousTol(double connAmbiguousTol) {
        this.connAmbiguousTol = connAmbiguousTol;
    }

    public void setConnMaxNeighbors(int connMaxNeighbors) {
        this.connMaxNeighbors = connMaxNeighbors;
    }

    public void setConnMaxNeighborDistance(double connMaxNeighborDistance) {
        this.connMaxNeighborDistance = connMaxNeighborDistance;
    }

    public void setGridRequireCornerSquares(boolean gridRequireCornerSquares) {
        this.gridRequireCornerSquares = gridRequireCornerSquares;
    }
}

