/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughTransformGradient;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.line.LineParametric2D_F32;
import java.util.List;

public class HoughGradient_to_DetectLine<I extends ImageGray<I>, D extends ImageGray<D>>
implements DetectLine<I> {
    HoughTransformGradient<D> hough;
    ImageGradient<I, D> gradient;
    D derivX;
    D derivY;
    GrayF32 edgeIntensity = new GrayF32(1, 1);
    GrayF32 suppressed = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    public float thresholdEdge = 20.0f;
    public boolean nonMaxSuppression = true;
    Class<I> inputType;
    Class<D> derivType;

    public HoughGradient_to_DetectLine(HoughTransformGradient hough, ImageGradient<I, D> gradient, Class<I> inputType) {
        this.hough = hough;
        this.gradient = gradient;
        this.inputType = inputType;
        this.derivType = GImageDerivativeOps.getDerivativeType(inputType);
        this.derivX = GeneralizedImageOps.createSingleBand(this.derivType, 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(this.derivType, 1, 1);
    }

    @Override
    public List<LineParametric2D_F32> detect(I input) {
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.edgeIntensity);
        if (this.nonMaxSuppression) {
            GGradientToEdgeFeatures.nonMaxSuppressionCrude4(this.edgeIntensity, this.derivX, this.derivY, this.suppressed);
            ThresholdImageOps.threshold(this.suppressed, this.binary, this.thresholdEdge, false);
        } else {
            ThresholdImageOps.threshold(this.edgeIntensity, this.binary, this.thresholdEdge, false);
        }
        this.hough.transform(this.derivX, this.derivY, this.binary);
        return this.hough.getLinesMerged();
    }

    @Override
    public ImageType<I> getInputType() {
        return ImageType.single(this.inputType);
    }

    public float getThresholdEdge() {
        return this.thresholdEdge;
    }

    public void setThresholdEdge(float thresholdEdge) {
        this.thresholdEdge = thresholdEdge;
    }

    public GrayF32 getEdgeIntensity() {
        return this.edgeIntensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public HoughTransformGradient<D> getHough() {
        return this.hough;
    }

    public ImageGradient<I, D> getGradient() {
        return this.gradient;
    }

    public D getDerivX() {
        return this.derivX;
    }

    public D getDerivY() {
        return this.derivY;
    }

    public boolean isNonMaxSuppression() {
        return this.nonMaxSuppression;
    }

    public void setNonMaxSuppression(boolean nonMaxSuppression) {
        this.nonMaxSuppression = nonMaxSuppression;
    }
}

