/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;

public class WrapSiftDetector<T extends ImageGray<T>>
implements InterestPointDetector<T> {
    SiftDetector detector;
    GrayF32 imageFloat = new GrayF32(1, 1);
    ImageType<T> inputType;

    public WrapSiftDetector(SiftDetector detector, Class<T> inputType) {
        this.detector = detector;
        this.inputType = ImageType.single(inputType);
    }

    @Override
    public void detect(T image) {
        GrayF32 input;
        if (!this.inputType.getDataType().isInteger()) {
            input = (GrayF32)image;
        } else {
            this.imageFloat.reshape(((ImageGray)image).width, ((ImageGray)image).height);
            GConvertImage.convert(image, this.imageFloat);
            input = this.imageFloat;
        }
        this.detector.process(input);
    }

    @Override
    public int getNumberOfSets() {
        return 2;
    }

    @Override
    public int getSet(int index) {
        return this.detector.getDetections().get((int)index).white ? 0 : 1;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getDetections().size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.detector.getDetections().get((int)featureIndex).pixel;
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.detector.getDetections().get((int)featureIndex).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

