/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;

public class InterestPointDetectorOverride<T extends ImageGray<T>>
implements InterestPointDetector<T> {
    InterestPointDetector<T> detector;
    OrientationImage<T> orientation;

    public InterestPointDetectorOverride(InterestPointDetector<T> detector, OrientationImage<T> orientation) {
        this.detector = detector;
        this.orientation = orientation;
    }

    @Override
    public void detect(T input) {
        this.detector.detect(input);
        if (this.orientation != null) {
            this.orientation.setImage(input);
        }
    }

    @Override
    public int getNumberOfSets() {
        return this.detector.getNumberOfSets();
    }

    @Override
    public int getSet(int index) {
        return this.detector.getSet(index);
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.detector.getLocation(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.detector.getRadius(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        if (this.orientation == null) {
            return this.detector.getOrientation(featureIndex);
        }
        Point2D_F64 p = this.detector.getLocation(featureIndex);
        this.orientation.setObjectRadius(this.getRadius(featureIndex));
        return this.orientation.compute(p.x, p.y);
    }

    @Override
    public boolean hasScale() {
        return this.detector.hasScale();
    }

    @Override
    public boolean hasOrientation() {
        if (this.orientation == null) {
            return this.detector.hasOrientation();
        }
        return true;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.detector.getInputType();
    }
}

