/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.extract;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensity;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class NonMaxLimiter {
    NonMaxSuppression nonmax;
    int maxTotalFeatures;
    QueueCorner originalMin = new QueueCorner();
    QueueCorner originalMax = new QueueCorner();
    FeatureSelectLimitIntensity<LocalExtreme> selector;
    DogArray<LocalExtreme> foundAll = new DogArray<LocalExtreme>(LocalExtreme::new);
    FastArray<LocalExtreme> foundSelected = new FastArray<LocalExtreme>(LocalExtreme.class);

    public NonMaxLimiter(NonMaxSuppression nonmax, FeatureSelectLimitIntensity<LocalExtreme> selector, int maxTotalFeatures) {
        this.nonmax = nonmax;
        this.selector = selector;
        this.maxTotalFeatures = maxTotalFeatures;
        selector.setSampler(new SampleIntensity<LocalExtreme>(){

            @Override
            public float sample(@Nullable GrayF32 intensity, int index, LocalExtreme p) {
                return p.intensity;
            }

            @Override
            public int getX(LocalExtreme p) {
                return p.location.x;
            }

            @Override
            public int getY(LocalExtreme p) {
                return p.location.y;
            }
        });
    }

    public void process(GrayF32 intensity) {
        float val2;
        Point2D_I16 p;
        int i;
        this.originalMin.reset();
        this.originalMax.reset();
        this.nonmax.process(intensity, null, null, this.originalMin, this.originalMax);
        this.foundAll.reset();
        for (i = 0; i < this.originalMin.size; ++i) {
            p = (Point2D_I16)this.originalMin.get(i);
            val2 = intensity.unsafe_get(p.x, p.y);
            this.foundAll.grow().set(-val2, false, p);
        }
        for (i = 0; i < this.originalMax.size; ++i) {
            p = (Point2D_I16)this.originalMax.get(i);
            val2 = intensity.unsafe_get(p.x, p.y);
            this.foundAll.grow().set(val2, true, p);
        }
        if (this.maxTotalFeatures > 0) {
            this.selector.select(intensity, -1, -1, true, null, this.foundAll, this.maxTotalFeatures, this.foundSelected);
        } else {
            this.foundSelected.clear();
            this.foundSelected.addAll(this.foundAll);
        }
    }

    public FastAccess<LocalExtreme> getFeatures() {
        return this.foundSelected;
    }

    public NonMaxSuppression getNonmax() {
        return this.nonmax;
    }

    public int getMaxTotalFeatures() {
        return this.maxTotalFeatures;
    }

    public void setMaxTotalFeatures(int maxTotalFeatures) {
        this.maxTotalFeatures = maxTotalFeatures;
    }

    public static class LocalExtreme
    implements Comparable<LocalExtreme> {
        public float intensity;
        public boolean max;
        public Point2D_I16 location;

        public LocalExtreme set(float intensity, boolean max, Point2D_I16 location) {
            this.intensity = intensity;
            this.max = max;
            this.location = location;
            return this;
        }

        public float getValue() {
            if (this.max) {
                return this.intensity;
            }
            return -this.intensity;
        }

        @Override
        public int compareTo(LocalExtreme o) {
            if (this.intensity < o.intensity) {
                return 1;
            }
            if (this.intensity > o.intensity) {
                return -1;
            }
            return 0;
        }
    }
}

