/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;

public class DetectDescribe_CompleteSift<I extends ImageGray<I>>
implements DetectDescribePoint<I, TupleDesc_F64> {
    CompleteSift alg;
    GrayF32 imageFloat = new GrayF32(1, 1);
    ImageType<I> inputType;

    public DetectDescribe_CompleteSift(CompleteSift alg, Class<I> inputType) {
        this.alg = alg;
        this.inputType = ImageType.single(inputType);
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.alg.getDescriptorLength());
    }

    @Override
    public TupleDesc_F64 getDescription(int index) {
        return ((TupleDesc_F64[])this.alg.getDescriptions().data)[index];
    }

    @Override
    public ImageType<I> getInputType() {
        return this.inputType;
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }

    @Override
    public void detect(I input) {
        if (!this.inputType.getDataType().isInteger()) {
            this.alg.process((GrayF32)input);
        } else {
            this.imageFloat.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, this.imageFloat);
            this.alg.process(this.imageFloat);
        }
    }

    @Override
    public int getNumberOfSets() {
        return 2;
    }

    @Override
    public int getSet(int index) {
        return this.alg.getLocations().get((int)index).white ? 0 : 1;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.alg.getDescriptions().size;
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.alg.getLocations().get((int)featureIndex).pixel;
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.alg.getLocations().get((int)featureIndex).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.alg.getOrientations().get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }
}

