/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class WrapDescribeBrief<T extends ImageGray<T>>
implements DescribeRegionPoint<T, TupleDesc_B> {
    int length;
    DescribePointBrief<T> alg;
    ImageType<T> imageType;

    public WrapDescribeBrief(DescribePointBrief<T> alg, Class<T> imageType) {
        this.alg = alg;
        this.length = alg.getDefinition().getLength();
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public TupleDesc_B createDescription() {
        return new TupleDesc_B(this.length);
    }

    @Override
    public void setImage(T image) {
        this.alg.setImage(image);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, TupleDesc_B storage) {
        this.alg.process(x, y, storage);
        return true;
    }

    @Override
    public boolean isScalable() {
        return false;
    }

    @Override
    public boolean isOriented() {
        return false;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public Class<TupleDesc_B> getDescriptionType() {
        return TupleDesc_B.class;
    }

    @Override
    public double getCanonicalWidth() {
        return this.alg.getDefinition().radius * 2 + 1;
    }
}

