/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.alg.feature.associate.AssociateGreedyDescBase;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public class WrapAssociateGreedy<T>
implements AssociateDescription<T> {
    AssociateGreedyDescBase<T> alg;
    DogArray<AssociatedIndex> matches = new DogArray<AssociatedIndex>(10, AssociatedIndex::new);
    FastAccess<T> listSrc;
    FastAccess<T> listDst;
    DogArray_I32 unassocSrc = new DogArray_I32();
    FindUnassociated unassociated = new FindUnassociated();

    public WrapAssociateGreedy(AssociateGreedyDescBase<T> alg) {
        this.alg = alg;
    }

    @Override
    public void setSource(FastAccess<T> listSrc) {
        this.listSrc = listSrc;
    }

    @Override
    public void setDestination(FastAccess<T> listDst) {
        this.listDst = listDst;
    }

    public DogArray<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public void associate() {
        if (this.listSrc == null) {
            throw new IllegalArgumentException("source features not specified");
        }
        if (this.listDst == null) {
            throw new IllegalArgumentException("destination features not specified");
        }
        this.unassocSrc.reset();
        this.alg.associate(this.listSrc, this.listDst);
        DogArray_I32 pairs = this.alg.getPairs();
        DogArray_F64 score = this.alg.getFitQuality();
        this.matches.reset();
        for (int i = 0; i < this.listSrc.size; ++i) {
            int dst = pairs.data[i];
            if (dst >= 0) {
                this.matches.grow().setTo(i, dst, score.data[i]);
                continue;
            }
            this.unassocSrc.add(i);
        }
    }

    @Override
    public DogArray_I32 getUnassociatedSource() {
        return this.unassocSrc;
    }

    @Override
    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.listDst.size);
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.alg.setMaxFitError(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.alg.getScore().getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return true;
    }

    @Override
    public boolean uniqueDestination() {
        return this.alg.isBackwardsValidation();
    }
}

