/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.BaseAssociateSets;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.DogArray;

public class AssociateDescriptionSets2D<Desc>
extends BaseAssociateSets<Desc> {
    AssociateDescription2D<Desc> associator;

    public AssociateDescriptionSets2D(AssociateDescription2D<Desc> associator, Class<Desc> type) {
        super(associator, type);
        this.associator = associator;
    }

    public void initialize(int imageWidth, int imageHeight) {
        this.associator.initialize(imageWidth, imageHeight);
    }

    @Override
    protected BaseAssociateSets.SetStruct newSetStruct() {
        return new SetStruct2D();
    }

    @Override
    public void clearSource() {
        super.clearSource();
        for (int i = 0; i < this.sets.size; ++i) {
            SetStruct2D set = (SetStruct2D)this.sets.get(i);
            set.pixelsSrc.reset();
        }
    }

    @Override
    public void clearDestination() {
        super.clearDestination();
        for (int i = 0; i < this.sets.size; ++i) {
            SetStruct2D set = (SetStruct2D)this.sets.get(i);
            set.pixelsDst.reset();
        }
    }

    public void addSource(Desc description, double pixelX, double pixelY, int set) {
        SetStruct2D ss = (SetStruct2D)((BaseAssociateSets.SetStruct[])this.sets.data)[set];
        ss.src.add(description);
        ss.pixelsSrc.grow().setTo(pixelX, pixelY);
        ss.indexSrc.add(this.countSrc++);
    }

    public void addDestination(Desc description, double pixelX, double pixelY, int set) {
        SetStruct2D ss = (SetStruct2D)((BaseAssociateSets.SetStruct[])this.sets.data)[set];
        ss.dst.add(description);
        ss.pixelsDst.grow().setTo(pixelX, pixelY);
        ss.indexDst.add(this.countDst++);
    }

    @Override
    public void associate() {
        if (this.sets.size <= 0) {
            throw new IllegalArgumentException("You must initialize first with the number of sets");
        }
        this.matches.reset();
        this.unassociatedSrc.reset();
        this.unassociatedDst.reset();
        for (int setIdx = 0; setIdx < this.sets.size; ++setIdx) {
            SetStruct2D set = (SetStruct2D)this.sets.get(setIdx);
            this.associator.setSource(set.pixelsSrc, set.src);
            this.associator.setDestination(set.pixelsDst, set.dst);
            this.associator.associate();
            this.saveSetAssociateResults(set);
        }
    }

    class SetStruct2D
    extends BaseAssociateSets.SetStruct {
        DogArray<Point2D_F64> pixelsSrc;
        DogArray<Point2D_F64> pixelsDst;

        SetStruct2D() {
            super(AssociateDescriptionSets2D.this);
            this.pixelsSrc = new DogArray<Point2D_F64>(Point2D_F64::new);
            this.pixelsDst = new DogArray<Point2D_F64>(Point2D_F64::new);
        }

        @Override
        public void reset() {
            super.reset();
            this.pixelsSrc.reset();
            this.pixelsDst.reset();
        }
    }
}

