/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.affine.Affine2D_F32;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.point.Point2D_F32;

public class FDistort {
    ImageType inputType;
    ImageBase input;
    ImageBase output;
    ImageDistort distorter;
    InterpolatePixel interp;
    PixelTransform<Point2D_F32> outputToInput;
    BorderType borderType;
    boolean cached = false;

    public FDistort(ImageBase input, ImageBase output) {
        this.init(input, output);
    }

    public FDistort(ImageType inputType) {
        this.inputType = inputType;
    }

    public FDistort() {
    }

    public FDistort init(ImageBase input, ImageBase output) {
        this.input = input;
        this.output = output;
        this.inputType = input.getImageType();
        this.interp(InterpolationType.BILINEAR);
        this.border(0.0);
        this.cached = false;
        this.distorter = null;
        this.outputToInput = null;
        return this;
    }

    public FDistort setRefs(ImageBase input, ImageBase output) {
        this.input = input;
        this.output = output;
        this.inputType = input.getImageType();
        return this;
    }

    public FDistort input(ImageBase input) {
        if (this.input == null || this.input.width != input.width || this.input.height != input.height) {
            this.distorter = null;
        }
        this.input = input;
        this.inputType = input.getImageType();
        return this;
    }

    public FDistort output(ImageBase output) {
        if (this.output == null || this.output.width != output.width || this.output.height != output.height) {
            this.distorter = null;
        }
        this.output = output;
        return this;
    }

    public FDistort border(ImageBorder border) {
        if (border == null) {
            this.borderType = BorderType.SKIP;
            this.interp.setBorder(FactoryImageBorder.generic(BorderType.EXTENDED, this.inputType));
        } else {
            this.borderType = null;
            this.interp.setBorder(border);
        }
        return this;
    }

    public FDistort border(BorderType type) {
        if (this.borderType == type) {
            return this;
        }
        if (type == BorderType.SKIP) {
            return this.border((ImageBorder)null);
        }
        this.border(FactoryImageBorder.generic(type, this.inputType));
        this.borderType = type;
        return this;
    }

    public FDistort border(double value) {
        this.borderType = BorderType.ZERO;
        return this.border(FactoryImageBorder.genericValue(value, this.inputType));
    }

    public FDistort borderExt() {
        return this.border(BorderType.EXTENDED);
    }

    public FDistort interp(InterpolatePixelS interpolation) {
        this.distorter = null;
        this.interp = interpolation;
        return this;
    }

    public FDistort interp(InterpolationType type) {
        this.distorter = null;
        this.interp = FactoryInterpolation.createPixel(0.0, 255.0, type, BorderType.EXTENDED, this.inputType);
        return this;
    }

    public FDistort interpNN() {
        return this.interp(InterpolationType.NEAREST_NEIGHBOR);
    }

    public FDistort cached(boolean cached) {
        this.distorter = null;
        this.cached = cached;
        return this;
    }

    public FDistort transform(PixelTransform<Point2D_F32> outputToInput) {
        this.outputToInput = outputToInput;
        return this;
    }

    public FDistort transform(Point2Transform2_F32 outputToInput) {
        return this.transform(new PointToPixelTransform_F32(outputToInput));
    }

    public FDistort affine(double a11, double a12, double a21, double a22, double dx, double dy) {
        PixelTransformAffine_F32 transform = this.outputToInput != null && this.outputToInput instanceof PixelTransformAffine_F32 ? (PixelTransformAffine_F32)this.outputToInput : new PixelTransformAffine_F32();
        Affine2D_F32 m = new Affine2D_F32();
        m.a11 = (float)a11;
        m.a12 = (float)a12;
        m.a21 = (float)a21;
        m.a22 = (float)a22;
        m.tx = (float)dx;
        m.ty = (float)dy;
        m.invert(transform.getModel());
        return this.transform(transform);
    }

    public FDistort affine(Affine2D_F64 affine) {
        return this.affine(affine.a11, affine.a12, affine.a21, affine.a22, affine.tx, affine.ty);
    }

    public FDistort scale() {
        if (this.outputToInput != null && this.outputToInput instanceof PixelTransformAffine_F32) {
            PixelTransformAffine_F32 affine = (PixelTransformAffine_F32)this.outputToInput;
            DistortSupport.transformScale(this.output, this.input, affine);
            return this;
        }
        return this.transform(DistortSupport.transformScale(this.output, this.input, null));
    }

    public FDistort scaleExt() {
        return this.scale().borderExt();
    }

    public FDistort rotate(double angleInputToOutput) {
        PixelTransformAffine_F32 outputToInput = DistortSupport.transformRotate(this.input.width / 2, this.input.height / 2, this.output.width / 2, this.output.height / 2, (float)angleInputToOutput);
        return this.transform(outputToInput);
    }

    public FDistort apply() {
        if (this.distorter == null) {
            Class typeOut = this.output.getImageType().getImageClass();
            switch (this.input.getImageType().getFamily()) {
                case GRAY: {
                    this.distorter = FactoryDistort.distortSB(this.cached, (InterpolatePixelS)this.interp, typeOut);
                    break;
                }
                case PLANAR: {
                    this.distorter = FactoryDistort.distortPL(this.cached, (InterpolatePixelS)this.interp, typeOut);
                    break;
                }
                case INTERLEAVED: {
                    this.distorter = FactoryDistort.distortIL(this.cached, (InterpolatePixelMB)this.interp, this.output.getImageType());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image type");
                }
            }
        }
        this.distorter.setModel(this.outputToInput);
        this.distorter.setRenderAll(this.borderType != BorderType.SKIP);
        this.distorter.apply(this.input, this.output);
        return this;
    }

    public ImageType getInputType() {
        return this.inputType;
    }

    public PixelTransform<Point2D_F32> getOutputToInput() {
        return this.outputToInput;
    }

    public BorderType getBorderType() {
        return this.borderType;
    }

    public boolean isCached() {
        return this.cached;
    }
}

