# Contributing to SeleniumBase

The SeleniumBase project welcomes meaningful contributions.

There are many ways to help:

## Bug Reports

When opening a new issue or commenting on an existing issue, please make sure to provide concise, detailed instructions on how to reproduce the issue. If the issue can't be reproduced, it will be closed. Clearly describe the results you're seeing, and the results you're expecting.

## Feature Requests

If you find that SeleniumBase is missing something, feel free to open an issue with details describing what feature(s) you'd like added or changed.  

## Documentation

SeleniumBase is a big software project, and documentation is key to
understanding how it works and how to use it properly. If you feel that important documentation is missing, please let us know, or submit a pull request.

## Code Contributions

The SeleniumBase project welcomes meaningful contributions. Given the complexity of the project, it may be easier to open an issue for a change you want made than to try implementing the change yourself.

## (A Note on Style Guide Rules)

[flake8](https://github.com/PyCQA/flake8) is the law of the land. The only flake8 rule ignored is [W503](https://github.com/grantmcconnaughey/Flake8Rules/blob/master/_rules/W503.md). For more details on why W503 should be ignored, see [this explanation](https://peps.python.org/pep-0008/#should-a-line-break-before-or-after-a-binary-operator), or [this shorter explanation](https://github.com/PyCQA/flake8/issues/494) by Python expert [Anthony Sottile](https://github.com/asottile).

--------

For questions about this document, reach out to [Michael Mintz](https://github.com/mdmintz).
