# encoding: utf-8


class CxOsaVulnerability(object):
    """
    osa scan vulnerabilities
    """

    def __init__(self, vulnerability_id, cve_name, score, severity, publish_date, url, description, recommendations,
                 source_file_name, library_id, state, comments_amount, similarity_id, fix_url):
        """

        Args:
            vulnerability_id (str):
            cve_name (str):
            score (float):
            severity (:obj:`CxOsaSeverity`):
            publish_date (str):
            url (str):
            description (str):
            recommendations (str):
            source_file_name (str):
            library_id (str):
            state (:obj:`CxOsaVulnerabilityState`):
            comments_amount (int):
            similarity_id (str):
            fix_url (str):

        """
        self.id = vulnerability_id
        self.cve_name = cve_name
        self.score = score
        self.severity = severity
        self.publish_date = publish_date
        self.url = url
        self.description = description
        self.recommendations = recommendations
        self.source_file_name = source_file_name
        self.library_id = library_id
        self.state = state
        self.comments_amount = comments_amount
        self.similarity_id = similarity_id
        self.fix_url = fix_url

    def __str__(self):
        return """CxOsaVulnerability(id={}, cve_name={}, score={}, severity={}, publish_date={}, url={}, description={},
                recommendations={}, source_file_name={}, library_id={}, state={}, comments_amount={}, 
                similarity_id={}, fix_url={})""".format(
            self.id, self.cve_name, self.score, self.severity, self.publish_date, self.url, self.description,
            self.recommendations, self.source_file_name, self.library_id, self.state, self.comments_amount,
            self.similarity_id, self.fix_url
        )
