"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) The websocket URL to this stage.
     *
     * @experimental
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * (experimental) The callback URL to this stage.
     *
     * @experimental
     */
    get callbackUrl() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketStage", version: "2.0.0-alpha.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFnZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFvQztBQUVwQyxtRUFBd0Q7QUFFeEQseUNBQTJDOzs7Ozs7O0FBNEIzQyxNQUFhLGNBQWUsU0FBUSxnQkFBUzs7OztJQXVCM0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsU0FBUztTQUM5QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDbEMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQzlCLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUVuQyxJQUFJLDJCQUFRLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM3QixLQUFLLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQyxLQUFLO1lBQy9CLFNBQVMsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUM1QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDN0IsQ0FBQyxDQUFDO1FBRUgsSUFBSSxLQUFLLENBQUMsYUFBYSxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDN0M7SUFDSCxDQUFDOzs7Ozs7SUF2Q00sTUFBTSxDQUFDLDRCQUE0QixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQStCO1FBQ3RHLE1BQU0sTUFBTyxTQUFRLGdCQUFTO1lBQTlCOztnQkFDa0IsWUFBTyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7Z0JBQ3BCLGNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUM1QixRQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztZQVNsQyxDQUFDO1lBUEMsSUFBSSxHQUFHO2dCQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLENBQUMsQ0FBQztZQUMvRCxDQUFDO1lBRUQsSUFBSSxXQUFXO2dCQUNiLE1BQU0sSUFBSSxLQUFLLENBQUMsb0RBQW9ELENBQUMsQ0FBQztZQUN4RSxDQUFDO1NBQ0Y7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztJQUMvQixDQUFDOzs7Ozs7SUEyQkQsSUFBVyxHQUFHO1FBQ1osTUFBTSxDQUFDLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDekIsTUFBTSxPQUFPLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMvQixPQUFPLFNBQVMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLGdCQUFnQixDQUFDLENBQUMsTUFBTSxJQUFJLENBQUMsQ0FBQyxTQUFTLElBQUksT0FBTyxFQUFFLENBQUM7SUFDckYsQ0FBQzs7Ozs7O0lBR0QsSUFBVyxXQUFXO1FBQ3BCLE1BQU0sQ0FBQyxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3pCLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDL0IsT0FBTyxXQUFXLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxnQkFBZ0IsQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLENBQUMsU0FBUyxJQUFJLE9BQU8sRUFBRSxDQUFDO0lBQ3ZGLENBQUM7O0FBdkRILHdDQXdEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5TdGFnZSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5djInO1xuaW1wb3J0IHsgU3RhZ2VPcHRpb25zLCBJQXBpLCBJU3RhZ2UsIFN0YWdlQXR0cmlidXRlcyB9IGZyb20gJy4uL2NvbW1vbic7XG5pbXBvcnQgeyBTdGFnZUJhc2UgfSBmcm9tICcuLi9jb21tb24vYmFzZSc7XG5pbXBvcnQgeyBJV2ViU29ja2V0QXBpIH0gZnJvbSAnLi9hcGknO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElXZWJTb2NrZXRTdGFnZSBleHRlbmRzIElTdGFnZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhcGk6IElXZWJTb2NrZXRBcGk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2FsbGJhY2tVcmw6IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgV2ViU29ja2V0U3RhZ2VQcm9wcyBleHRlbmRzIFN0YWdlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgd2ViU29ja2V0QXBpOiBJV2ViU29ja2V0QXBpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3RhZ2VOYW1lOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgV2ViU29ja2V0U3RhZ2VBdHRyaWJ1dGVzIGV4dGVuZHMgU3RhZ2VBdHRyaWJ1dGVzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBpOiBJV2ViU29ja2V0QXBpO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgV2ViU29ja2V0U3RhZ2UgZXh0ZW5kcyBTdGFnZUJhc2UgaW1wbGVtZW50cyBJV2ViU29ja2V0U3RhZ2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVdlYlNvY2tldFN0YWdlQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBhdHRyczogV2ViU29ja2V0U3RhZ2VBdHRyaWJ1dGVzKTogSVdlYlNvY2tldFN0YWdlIHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBTdGFnZUJhc2UgaW1wbGVtZW50cyBJV2ViU29ja2V0U3RhZ2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGJhc2VBcGkgPSBhdHRycy5hcGk7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgc3RhZ2VOYW1lID0gYXR0cnMuc3RhZ2VOYW1lO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGFwaSA9IGF0dHJzLmFwaTtcblxuICAgICAgZ2V0IHVybCgpOiBzdHJpbmcge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ3VybCBpcyBub3QgYXZhaWxhYmxlIGZvciBpbXBvcnRlZCBzdGFnZXMuJyk7XG4gICAgICB9XG5cbiAgICAgIGdldCBjYWxsYmFja1VybCgpOiBzdHJpbmcge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ2NhbGxiYWNrIHVybCBpcyBub3QgYXZhaWxhYmxlIGZvciBpbXBvcnRlZCBzdGFnZXMuJyk7XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCk7XG4gIH1cblxuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYmFzZUFwaTogSUFwaTtcbiAgcHVibGljIHJlYWRvbmx5IHN0YWdlTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYXBpOiBJV2ViU29ja2V0QXBpO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBXZWJTb2NrZXRTdGFnZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLnN0YWdlTmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMuYmFzZUFwaSA9IHByb3BzLndlYlNvY2tldEFwaTtcbiAgICB0aGlzLmFwaSA9IHByb3BzLndlYlNvY2tldEFwaTtcbiAgICB0aGlzLnN0YWdlTmFtZSA9IHRoaXMucGh5c2ljYWxOYW1lO1xuXG4gICAgbmV3IENmblN0YWdlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGFwaUlkOiBwcm9wcy53ZWJTb2NrZXRBcGkuYXBpSWQsXG4gICAgICBzdGFnZU5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgYXV0b0RlcGxveTogcHJvcHMuYXV0b0RlcGxveSxcbiAgICB9KTtcblxuICAgIGlmIChwcm9wcy5kb21haW5NYXBwaW5nKSB7XG4gICAgICB0aGlzLl9hZGREb21haW5NYXBwaW5nKHByb3BzLmRvbWFpbk1hcHBpbmcpO1xuICAgIH1cbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgdXJsKCk6IHN0cmluZyB7XG4gICAgY29uc3QgcyA9IFN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IHVybFBhdGggPSB0aGlzLnN0YWdlTmFtZTtcbiAgICByZXR1cm4gYHdzczovLyR7dGhpcy5hcGkuYXBpSWR9LmV4ZWN1dGUtYXBpLiR7cy5yZWdpb259LiR7cy51cmxTdWZmaXh9LyR7dXJsUGF0aH1gO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZ2V0IGNhbGxiYWNrVXJsKCk6IHN0cmluZyB7XG4gICAgY29uc3QgcyA9IFN0YWNrLm9mKHRoaXMpO1xuICAgIGNvbnN0IHVybFBhdGggPSB0aGlzLnN0YWdlTmFtZTtcbiAgICByZXR1cm4gYGh0dHBzOi8vJHt0aGlzLmFwaS5hcGlJZH0uZXhlY3V0ZS1hcGkuJHtzLnJlZ2lvbn0uJHtzLnVybFN1ZmZpeH0vJHt1cmxQYXRofWA7XG4gIH1cbn1cbiJdfQ==