import { Construct } from 'constructs';
import { IApi } from '../common/api';
import { ApiBase } from '../common/base';
import { WebSocketRouteIntegrationConfig, WebSocketIntegration } from './integration';
import { WebSocketRoute, WebSocketRouteOptions } from './route';
/**
 * (experimental) Represents a WebSocket API.
 *
 * @experimental
 */
export interface IWebSocketApi extends IApi {
    /**
     * Add a websocket integration
     * @internal
     */
    _addIntegration(scope: Construct, config: WebSocketRouteIntegrationConfig): WebSocketIntegration;
}
/**
 * (experimental) Props for WebSocket API.
 *
 * @experimental
 */
export interface WebSocketApiProps {
    /**
     * (experimental) Name for the WebSocket API resource.
     *
     * @default - id of the WebSocketApi construct.
     * @experimental
     */
    readonly apiName?: string;
    /**
     * (experimental) The description of the API.
     *
     * @default - none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The route selection expression for the API.
     *
     * @default '$request.body.action'
     * @experimental
     */
    readonly routeSelectionExpression?: string;
    /**
     * (experimental) Options to configure a '$connect' route.
     *
     * @default - no '$connect' route configured
     * @experimental
     */
    readonly connectRouteOptions?: WebSocketRouteOptions;
    /**
     * (experimental) Options to configure a '$disconnect' route.
     *
     * @default - no '$disconnect' route configured
     * @experimental
     */
    readonly disconnectRouteOptions?: WebSocketRouteOptions;
    /**
     * (experimental) Options to configure a '$default' route.
     *
     * @default - no '$default' route configured
     * @experimental
     */
    readonly defaultRouteOptions?: WebSocketRouteOptions;
}
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
export declare class WebSocketApi extends ApiBase implements IWebSocketApi {
    /**
     * (experimental) The identifier of this API Gateway API.
     *
     * @experimental
     */
    readonly apiId: string;
    /**
     * (experimental) The default endpoint for an API.
     *
     * @experimental
     */
    readonly apiEndpoint: string;
    /**
     * (experimental) A human friendly name for this WebSocket API.
     *
     * Note that this is different from `webSocketApiId`.
     *
     * @experimental
     */
    readonly webSocketApiName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: WebSocketApiProps);
    /**
     * @internal
     */
    _addIntegration(scope: Construct, config: WebSocketRouteIntegrationConfig): WebSocketIntegration;
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey: string, options: WebSocketRouteOptions): WebSocketRoute;
}
