# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class MlAssetsCreateModelInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self,
                 tags=None,
                 space=None,
                 project=None,
                 custom=None,
                 pipeline=None,
                 training_lib=None,
                 type=None,
                 domain=None,
                 name=None,
                 description=None,
                 transformed_label_column=None,
                 label_column=None,
                 training_data_references=None,
                 import_location=None,
                 size=None,
                 hyper_parameters=None,
                 runtime=None,
                 metrics=None,
                 schemas=None,
                 software_spec=None):
        """
        MlAssetsCreateModelInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'tags': 'list[TagRepository]',
            'space': 'ModelSpaces',
            'project': 'SpaceModels',
            'custom': 'ModelsCustom',
            'pipeline': 'PipelinesModels',
            'training_lib': 'TrainingModels',
            'type': 'str',
            'domain': 'str',
            'name': 'str',
            'description': 'str',
            'transformed_label_column': 'str',
            'label_column': 'str',
            'training_data_references': 'list[ModelContentLocation]',
            'import_location': 'ModelContentLocation',
            'size': 'ModelsSize',
            'hyper_parameters':'list[HyperParameters]',
            'runtime':'RuntimeModels',
            'metrics': 'ModelsMetrics',
            'schemas': 'ModelSchemas',
            'software_spec': 'SoftwareSpecModels'

        }

        self.attribute_map = {
            'tags': 'tags',
            'space': 'space',
            'project': 'project',
            'custom': 'custom',
            'pipeline': 'pipeline',
            'training_lib': 'training_lib',
            'type': 'type',
            'domain': 'domain',
            'name': 'name',
            'description': 'description',
            'transformed_label_column': 'transformed_label_column',
            'label_column': 'label_column',
            'training_data_references': 'training_data_references',
            'import_location': 'import',
            'size': 'size',
            'hyper_parameters':'hyper_parameters',
            'runtime':'runtime',
            'metrics': 'metrics',
            'schemas': 'schemas',
            'software_spec': 'software_spec'
        }

        self._tags = tags
        self._name = name
        self._description = description
        self._transformed_label_column = transformed_label_column
        self._label_column = label_column
        self._training_data_references = training_data_references
        self._schemas = schemas
        self._hyper_parameters = hyper_parameters
        self._runtime = runtime
        self._space = space
        self._project = project
        self._custom = custom
        self._pipeline =  pipeline
        self._training_lib =  training_lib
        self._type = type
        self._domain = domain
        self._import_location = import_location
        self._metrics = metrics
        self._size = size
        self.software_spec = software_spec

    @property
    def tags(self):
        """
        Gets the tags of this ExperimentInputExperiments.


        :return: The tags of this ExperimentInputExperiments.
        :rtype: list[TagRepository]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ExperimentInputExperiments.


        :param tags: The tags of this ExperimentInputExperiments.
        :type: list[TagRepository]
        """

        self._tags = tags

    @property
    def sofrware_spec(self):
        """
        Gets the software_spec of this Model


        :return: The tags of this models.
        :rtype: list[TagRepository]
        """
        return self._software_spec

    @sofrware_spec.setter
    def software_spec(self, software_spec):
        """
        Sets the tags of this ExperimentInputExperiments.


        :param tags: The tags of this ExperimentInputExperiments.
        :type: list[TagRepository]
        """

        self._software_spec = software_spec

    @property
    def hyper_parameters(self):
        """
        Gets the hyper_parameters of this MlAssetsCreateModelInput.


        :return: The hyper_parameters of this MlAssetsCreateModelInput.
        :rtype: HyperParameters
        """
        return self._hyper_parameters

    @hyper_parameters.setter
    def hyper_parameters(self, hyper_parameters):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: HyperParameters
        """
        self._hyper_parameters = hyper_parameters

    @property
    def custom(self):
        """
        Gets the custom of this MlAssetsCreateModelInput.


        :return: The custom of this MlAssetsCreateModelInput.
        :rtype: custom
        """
        return self._custom

    @custom.setter
    def custom(self, custom):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: custom
        """
        self._custom = custom

    @property
    def schemas(self):
        """
        Gets the hyper_parameters of this MlAssetsCreateModelInput.


        :return: The hyper_parameters of this MlAssetsCreateModelInput.
        :rtype: HyperParameters
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: HyperParameters
        """
        self._schemas = schemas

    @property
    def name(self):
        """
        Gets the name of this MlAssetsCreateModelInput.


        :return: The name of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MlAssetsCreateModelInput.


        :param name: The name of this MlAssetsCreateModelInput.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this MlAssetsCreateModelInput.


        :return: The description of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MlAssetsCreateModelInput.


        :param description: The description of this MlAssetsCreateModelInput.
        :type: str
        """
        self._description = description



    @property
    def transformed_label_column(self):
        """
        Gets the transformed_label_column of this MlAssetsCreateModelInput.


        :return: The transformed_label_column of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._transformed_label_column

    @transformed_label_column.setter
    def transformed_label_column(self, transformed_label_column):
        """
        Sets the transformed_label_column of this MlAssetsCreateModelInput.


        :param transformed_label_column: The transformed_label_column of this MlAssetsCreateModelInput.
        :type: str
        """
        self._transformed_label_column = transformed_label_column



    @property
    def label_column(self):
        """
        Gets the label_column of this MlAssetsCreateModelInput.
        Name of the label column

        :return: The label_column of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._label_column

    @label_column.setter
    def label_column(self, label_column):
        """
        Sets the label_column of this MlAssetsCreateModelInput.
        Name of the label column

        :param label_column: The label_column of this MlAssetsCreateModelInput.
        :type: str
        """
        self._label_column = label_column


    @property
    def training_data_references(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._training_data_references


    @training_data_references.setter
    def training_data_reference(self, training_data_references):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._training_data_references = training_data_references


    @property
    def evaluation(self):
        """
        Gets the evaluation of this MlAssetsCreateModelInput.
        Definition of the evaluation method used for pipeline models

        :return: The evaluation of this MlAssetsCreateModelInput.
        :rtype: EvaluationDefinitionRepository
        """
        return self._evaluation

    @evaluation.setter
    def evaluation(self, evaluation):
        """
        Sets the evaluation of this MlAssetsCreateModelInput.
        Definition of the evaluation method used for pipeline models

        :param evaluation: The evaluation of this MlAssetsCreateModelInput.
        :type: EvaluationDefinitionRepository
        """
        self._evaluation = evaluation


    @property
    def runtime(self):
        """
        Gets the runtime of this MlAssetsCreateModelInput.


        :return: The runtime of this MlAssetsCreateModelInput.
        :rtype: runtime
        """
        return self._runtime

    @runtime.setter
    def runtime(self, runtime):
        """
        Sets the runtime of this MlAssetsCreateModelInput.

        :param runtime: The runtime of this MlAssetsCreateModelInput.
        :type: runtime
        """
        self._runtime = runtime



    @property
    def space(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._space

    @space.setter
    def space(self, space):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._space = space

    @property
    def project(self):
        """
        Gets the project of this MlAssetsCreateModelInput.
        :return: The project of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Sets the project of this MlAssetsCreateModelInput.
        :param project: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._project = project

    @property
    def pipeline(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._pipeline

    @pipeline.setter
    def pipeline(self, pipeline):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._pipeline = pipeline



    @property
    def training_lib(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._training_lib

    @training_lib.setter
    def training_lib(self, training_lib):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._training_lib = training_lib

    @property
    def type(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._type = type

    @property
    def domain(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._domain = domain

    @property
    def metrics(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._metrics = metrics

    @property
    def import_location(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._import_location

    @import_location.setter
    def import_location(self, import_location):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._import_location = import_location

    @property
    def size(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._size = size



    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                if (attr == "import_location"):
                    result["import"] =  dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
                else:
                    result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if (attr == "import_location"):
                    result["import"] = value
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

