"""
Deformation forward modeling routines

Sill class (based on Fialko et al. 2001)
sphere2D function (based on McTigue 1987)
sphere3D_displ and sphere3D_strain functions (based on McTigue 1987)
spheroid and spheroid_displ functions (based on Yang et al. 1988)

==========================================================================
 USGS Software Disclaimer
 The software and related documentation were developed by the U.S.
 Geological Survey (USGS) for use by the USGS in fulfilling its mission.
 The software can be used, copied, modified, and distributed without any
 fee or cost. Use of appropriate credit is requested.

 The USGS provides no warranty, expressed or implied, as to the correctness
 of the furnished software or the suitability for any purpose. The software
 has been tested, but as with any complex software, there could be undetected
 errors. Users who find errors are requested to report them to the USGS.
 The USGS has limited resources to assist non-USGS users; however, we make
 an attempt to fix reported problems and help whenever possible.
==========================================================================
"""
from .mogi import Mogi
from .sill import Sill
from .sphere2D import Sphere2D
from .sphere3D import Sphere3D
from .spheroid import Spheroid

from .version import __version__

__bibtex__ = r"""
@Article{Fialko2001,
author = {Fialko, Yuri and Simons, Mark and Khazan, Yakov}, 
title = {Finite source modelling of magmatic unrest in Socorro, New Mexico, and Long Valley, California}, 
journal = {Geophys. J. Int.}, 
volume = {146}, 
number = {1}, 
pages = {191–200}, 
year = {2001}, 
abstract = {We investigate surface deformation associated with currently active crustal magma bodies in Socorro, New Mexico, and Long Valley, California, USA. We invert available geodetic data from these locations to constrain the overall geometry and dynamics of the inferred …}, 
location = {}, 
keywords = {}},

@Article{Yang1988,
author = {Yang, Xue‐Min and Davis, Paul M and Dieterich, James H}, 
title = {Deformation from inflation of a dipping finite prolate spheroid in an elastic half‐space as a model for volcanic stressing}, 
journal = {Journal of Geophysical Research: Solid Earth}, 
volume = {93}, 
number = {B5}, 
pages = {4249–4257}, 
year = {1988}, 
abstract = {Exact analytic expressions are given for the deformation field resulting from inflation of a finite prolate spheroidal cavity in an infinite elastic medium. The field is equivalent to that generated by a parabolic distribution of double forces and centers of dilatation along the …}, 
location = {}, 
keywords = {}},

@Article{McTigue1987,
author = {McTigue, DF}, 
title = {Elastic stress and deformation near a finite spherical magma body: resolution of the point source paradox}, 
journal = {Journal of Geophysical Research: Solid Earth}, 
volume = {92}, 
number = {B12}, 
pages = {12931–12940}, 
year = {1987}, 
abstract = {Approximate solutions are obtained for the stress and displacement fields due to a pressurized spherical cavity in an elastic half‐space. The solutions take the form of series expansions in powers of ε= a/d, where a is the cavity radius and d is the depth. The leading …}, 
location = {}, 
keywords = {}},

@Article{Battaglia2013,
author = {Battaglia, Maurizio and Cervelli, Peter F. and Murray, Jessica R.}, 
title = {dMODELS: A MATLAB software package for modeling crustal deformation near active faults and volcanic centers}, 
journal = {J. Volc. Geotherm. Res.}, 
volume = {254}, 
number = {}, 
pages = {1–4}, 
year = {2013}, 
abstract = {}, 
location = {}, 
keywords = {}},

@Article{Newman2006,
author = {Newman, Andrew V. and Dixon, Timothy H. and Gourmelen, Noel}, 
title = {A four-dimensional viscoelastic deformation model for Long Valley Caldera, California, between 1995 and 2000}, 
journal = {J. Volc. Geotherm. Res.}, 
volume = {150}, 
number = {1-3}, 
pages = {244--269}, 
year = {2006}, 
abstract = {}, 
location = {}, 
keywords = {}},

@Article{Mogi1958,
author = {Mogi, Kiyoo}, 
title = {Relations between the eruptions of various volcanoes and the deformatins of the ground surfaces around them}, 
journal = {Bull. Earthq Res Inst Univ Tokyo}, 
volume = {36}, 
number = {2}, 
pages = {99-134}, 
year = {1958}, 
abstract = {}, 
location = {}, 
keywords = {}}
"""
