/**
 * Available log levels for Flink applications.
 */
export declare enum LogLevel {
    /** Debug level logging */
    DEBUG = "DEBUG",
    /** Info level logging */
    INFO = "INFO",
    /** Warn level logging */
    WARN = "WARN",
    /** Error level logging */
    ERROR = "ERROR"
}
/**
 * Granularity of metrics sent to CloudWatch.
 */
export declare enum MetricsLevel {
    /** Application sends the least metrics to CloudWatch */
    APPLICATION = "APPLICATION",
    /** Task includes task-level metrics sent to CloudWatch */
    TASK = "TASK",
    /** Operator includes task-level and operator-level metrics sent to CloudWatch */
    OPERATOR = "OPERATOR",
    /** Send all metrics including metrics per task thread */
    PARALLELISM = "PARALLELISM"
}
/**
 * Interface for building AWS::KinesisAnalyticsV2::Application PropertyGroup
 * configuration.
 */
export interface PropertyGroups {
    readonly [propertyId: string]: {
        [mapKey: string]: string;
    };
}
/**
 * Available Flink runtimes for Kinesis Analytics.
 */
export declare class Runtime {
    /** Flink Version 1.6 */
    static readonly FLINK_1_6: Runtime;
    /** Flink Version 1.8 */
    static readonly FLINK_1_8: Runtime;
    /** Flink Version 1.11 */
    static readonly FLINK_1_11: Runtime;
    /** Flink Version 1.13 */
    static readonly FLINK_1_13: Runtime;
    /** Create a new Runtime with with an arbitrary Flink version string */
    static of(value: string): Runtime;
    /** The Cfn string that represents a version of Flink */
    readonly value: string;
    private constructor();
}
