/**
 * (experimental) Represents a Mapping Value.
 *
 * @experimental
 */
export interface IMappingValue {
    /**
     * (experimental) Represents a Mapping Value.
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) Represents a Mapping Value.
 *
 * @experimental
 */
export declare class MappingValue implements IMappingValue {
    /**
     * (experimental) Creates an empty mapping value.
     *
     * @experimental
     */
    static readonly NONE: MappingValue;
    /**
     * (experimental) Creates a header mapping value.
     *
     * @experimental
     */
    static requestHeader(name: string): MappingValue;
    /**
     * (experimental) Creates a query string mapping value.
     *
     * @experimental
     */
    static requestQueryString(name: string): MappingValue;
    /**
     * (experimental) Creates a request body mapping value.
     *
     * @experimental
     */
    static requestBody(name: string): MappingValue;
    /**
     * (experimental) Creates a request path mapping value.
     *
     * @experimental
     */
    static requestPath(): MappingValue;
    /**
     * (experimental) Creates a request path parameter mapping value.
     *
     * @experimental
     */
    static requestPathParam(name: string): MappingValue;
    /**
     * (experimental) Creates a context variable mapping value.
     *
     * @experimental
     */
    static contextVariable(variableName: string): MappingValue;
    /**
     * (experimental) Creates a stage variable mapping value.
     *
     * @experimental
     */
    static stageVariable(variableName: string): MappingValue;
    /**
     * (experimental) Creates a custom mapping value.
     *
     * @experimental
     */
    static custom(value: string): MappingValue;
    /**
     * (experimental) Represents a Mapping Value.
     *
     * @experimental
     */
    readonly value: string;
    /**
     * @experimental
     */
    protected constructor(value: string);
}
/**
 * (experimental) Represents a Parameter Mapping.
 *
 * @experimental
 */
export declare class ParameterMapping {
    /**
     * (experimental) Represents all created parameter mappings.
     *
     * @experimental
     */
    readonly mappings: {
        [key: string]: string;
    };
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Creates a mapping to append a header.
     *
     * @experimental
     */
    appendHeader(name: string, value: MappingValue): ParameterMapping;
    /**
     * (experimental) Creates a mapping to overwrite a header.
     *
     * @experimental
     */
    overwriteHeader(name: string, value: MappingValue): ParameterMapping;
    /**
     * (experimental) Creates a mapping to remove a header.
     *
     * @experimental
     */
    removeHeader(name: string): ParameterMapping;
    /**
     * (experimental) Creates a mapping to append a query string.
     *
     * @experimental
     */
    appendQueryString(name: string, value: MappingValue): ParameterMapping;
    /**
     * (experimental) Creates a mapping to overwrite a querystring.
     *
     * @experimental
     */
    overwriteQueryString(name: string, value: MappingValue): ParameterMapping;
    /**
     * (experimental) Creates a mapping to remove a querystring.
     *
     * @experimental
     */
    removeQueryString(name: string): ParameterMapping;
    /**
     * (experimental) Creates a mapping to overwrite a path.
     *
     * @experimental
     */
    overwritePath(value: MappingValue): ParameterMapping;
    /**
     * (experimental) Creates a custom mapping.
     *
     * @experimental
     */
    custom(key: string, value: string): ParameterMapping;
}
