"use strict";
const cdk = require("../lib");
const util_1 = require("./util");
module.exports = {
    'chain conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const param = new cdk.CfnParameter(stack, 'Param1', { type: 'String' });
        const cond1 = new cdk.CfnCondition(stack, 'Condition1', { expression: cdk.Fn.conditionEquals('a', 'b') });
        const cond2 = new cdk.CfnCondition(stack, 'Condition2', { expression: cdk.Fn.conditionContains(['a', 'b', 'c'], 'c') });
        const cond3 = new cdk.CfnCondition(stack, 'Condition3', { expression: cdk.Fn.conditionEquals(param, 'hello') });
        // WHEN
        new cdk.CfnCondition(stack, 'Condition4', {
            expression: cdk.Fn.conditionOr(cond1, cond2, cdk.Fn.conditionNot(cond3))
        });
        // THEN
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: { Param1: { Type: 'String' } },
            Conditions: {
                Condition1: { 'Fn::Equals': ['a', 'b'] },
                Condition2: { 'Fn::Contains': [['a', 'b', 'c'], 'c'] },
                Condition3: { 'Fn::Equals': [{ Ref: 'Param1' }, 'hello'] },
                Condition4: { 'Fn::Or': [
                        { Condition: 'Condition1' },
                        { Condition: 'Condition2' },
                        { 'Fn::Not': [{ Condition: 'Condition3' }] }
                    ] }
            }
        });
        test.done();
    },
    'condition expressions can be embedded as strings'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const propValue = cdk.Fn.conditionIf('Cond', 'A', 'B').toString();
        // WHEN
        new cdk.CfnResource(stack, 'MyResource', {
            type: 'AWS::Foo::Bar',
            properties: {
                StringProp: propValue
            }
        });
        // THEN
        test.ok(cdk.Token.isUnresolved(propValue));
        test.deepEqual(util_1.toCloudFormation(stack), {
            Resources: {
                MyResource: {
                    Type: 'AWS::Foo::Bar',
                    Properties: {
                        StringProp: { 'Fn::If': ['Cond', 'A', 'B'] }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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