"use strict";
const nodeunit = require("nodeunit");
const core = require("../lib");
module.exports = nodeunit.testCase({
    '._toCloudFormation': {
        'does not call renderProperties with an undefined value'(test) {
            const app = new core.App();
            const stack = new core.Stack(app, 'TestStack');
            const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
            let called = false;
            resource.renderProperties = (val) => {
                called = true;
                test.notEqual(val, null);
            };
            test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
                Resources: {
                    DefaultResource: {
                        Type: 'Test::Resource::Fake'
                    }
                }
            });
            test.ok(called, 'renderProperties must be called called');
            test.done();
        }
    },
    'applyRemovalPolicy default includes Update policy'(test) {
        // GIVEN
        const app = new core.App();
        const stack = new core.Stack(app, 'TestStack');
        const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
        // WHEN
        resource.applyRemovalPolicy(core.RemovalPolicy.RETAIN);
        // THEN
        test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
            Resources: {
                DefaultResource: {
                    Type: 'Test::Resource::Fake',
                    DeletionPolicy: 'Retain',
                    UpdateReplacePolicy: 'Retain',
                }
            }
        });
        test.done();
    },
    'can switch off updating Update policy'(test) {
        // GIVEN
        const app = new core.App();
        const stack = new core.Stack(app, 'TestStack');
        const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
        // WHEN
        resource.applyRemovalPolicy(core.RemovalPolicy.RETAIN, {
            applyToUpdateReplacePolicy: false
        });
        // THEN
        test.deepEqual(app.synth().getStackByName(stack.stackName).template, {
            Resources: {
                DefaultResource: {
                    Type: 'Test::Resource::Fake',
                    DeletionPolicy: 'Retain',
                }
            }
        });
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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