"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class CfnCondition extends cfn_element_1.CfnElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression
            }
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.CfnCondition = CfnCondition;
//# sourceMappingURL=data:application/json;base64,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