"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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