"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class TimeAgo {
    constructor() {
        this.timeAgo = (timeDifference) => {
            if (timeDifference < 0) {
                return 'just now';
            }
            else {
                const seconds = Math.round(timeDifference) / 1000;
                const minutes = Math.round(seconds / 60);
                const hours = Math.round(seconds / (60 * 60));
                const days = Math.round(seconds / (60 * 60 * 24));
                const months = Math.round(seconds / (60 * 60 * 24 * 30));
                const years = Math.round(seconds / (60 * 60 * 24 * 30 * 356.25));
                if (years > 0) {
                    return `${years} ${years === 1 ? 'year' : 'years'} ago`;
                }
                else if (months > 0) {
                    return `${months} ${months === 1 ? 'month' : 'months'} ago`;
                }
                else if (days > 0) {
                    return `${days} ${days === 1 ? 'day' : 'days'} ago`;
                }
                else if (hours > 0) {
                    return `${hours} ${hours === 1 ? 'hour' : 'hours'} ago`;
                }
                else if (minutes > 0) {
                    return `${minutes} ${minutes === 1 ? 'minute' : 'minutes'} ago`;
                }
                else {
                    return 'just now';
                }
            }
        };
    }
}
const timeAgo = new TimeAgo();
exports.default = timeAgo;
//# sourceMappingURL=data:application/json;base64,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