"use strict";
/// !cdk-integ canary-asset
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const cdk = require("@aws-cdk/core");
const synthetics = require("../lib");
/*
 * Stack verification steps:
 *
 * -- aws synthetics get-canary --name assetcanary-one has a state of 'RUNNING'
 * -- aws synthetics get-canary --name assetcanary-two has a state of 'RUNNING'
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'canary-asset');
new synthetics.Canary(stack, 'MyCanary', {
    canaryName: 'assetcanary-one',
    test: synthetics.Test.custom({
        handler: 'canary.handler',
        code: synthetics.Code.fromAsset(path.join(__dirname, 'canaries')),
    }),
});
new synthetics.Canary(stack, 'MyCanaryTwo', {
    canaryName: 'assetcanary-two',
    test: synthetics.Test.custom({
        handler: 'canary.handler',
        code: synthetics.Code.fromAsset(path.join(__dirname, 'canary.zip')),
    }),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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