import * as ka from '@aws-cdk/aws-kinesisanalytics';
import * as s3 from '@aws-cdk/aws-s3';
import * as s3_assets from '@aws-cdk/aws-s3-assets';
import { Construct } from '@aws-cdk/core';
/**
 * The return type of {@link ApplicationCode.bind}. This represents
 * CloudFormation configuration and an s3 bucket holding the Flink application
 * JAR file.
 */
export interface ApplicationCodeConfig {
    /**
     * Low-level Cloudformation ApplicationConfigurationProperty
     */
    readonly applicationCodeConfigurationProperty: ka.CfnApplicationV2.ApplicationConfigurationProperty;
    /**
     * S3 Bucket that stores the Flink application code
     */
    readonly bucket: s3.IBucket;
}
/**
 * Code configuration providing the location to a Flink application JAR file.
 */
export declare abstract class ApplicationCode {
    /**
     * Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket
     * @param fileKey - a key pointing to a Flink JAR file
     * @param objectVersion - an optional version string for the provided fileKey
     */
    static fromBucket(bucket: s3.IBucket, fileKey: string, objectVersion?: string): ApplicationCode;
    /**
     * Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path: string, options?: s3_assets.AssetOptions): ApplicationCode;
    /**
     * A method to lazily bind asset resources to the parent FlinkApplication.
     */
    abstract bind(scope: Construct): ApplicationCodeConfig;
}
