from dataclasses import dataclass
from typing import Tuple


@dataclass(frozen=True)
class Pin:
    pin_id: int
    is_pwm: int = False
    is_analog: bool = False


def get_uno_pins() -> Tuple[Pin, ...]:
    return (
        Pin(0),
        Pin(1),
        Pin(2),
        Pin(3, is_pwm=True),
        Pin(4),
        Pin(5, is_pwm=True),
        Pin(6, is_pwm=True),
        Pin(7),
        Pin(8),
        Pin(9, is_pwm=True),
        Pin(10, is_pwm=True),
        Pin(11, is_pwm=True),
        Pin(12),
        Pin(13),
        Pin(14, is_analog=True),
        Pin(15, is_analog=True),
        Pin(16, is_analog=True),
        Pin(17, is_analog=True),
        Pin(18, is_analog=True),
        Pin(19, is_analog=True),
    )


def get_mega2560_pins() -> Tuple[Pin, ...]:
    return (
        Pin(0),
        Pin(1),
        Pin(2, is_pwm=True),
        Pin(3, is_pwm=True),
        Pin(4, is_pwm=True),
        Pin(5, is_pwm=True),
        Pin(6, is_pwm=True),
        Pin(7, is_pwm=True),
        Pin(8, is_pwm=True),
        Pin(9, is_pwm=True),
        Pin(10, is_pwm=True),
        Pin(11, is_pwm=True),
        Pin(12, is_pwm=True),
        Pin(13, is_pwm=True),
        Pin(14),
        Pin(15),
        Pin(16),
        Pin(17),
        Pin(18),
        Pin(19),
        Pin(20),
        Pin(21),
        Pin(22),
        Pin(23),
        Pin(24),
        Pin(25),
        Pin(26),
        Pin(27),
        Pin(28),
        Pin(29),
        Pin(30),
        Pin(31),
        Pin(32),
        Pin(33),
        Pin(34),
        Pin(35),
        Pin(36),
        Pin(37),
        Pin(38),
        Pin(39),
        Pin(40),
        Pin(41),
        Pin(42),
        Pin(43),
        Pin(44, is_pwm=True),
        Pin(45, is_pwm=True),
        Pin(46, is_pwm=True),
        Pin(47),
        Pin(48),
        Pin(49),
        Pin(50),
        Pin(51),
        Pin(52),
        Pin(53),
        Pin(54, is_analog=True),
        Pin(55, is_analog=True),
        Pin(56, is_analog=True),
        Pin(57, is_analog=True),
        Pin(58, is_analog=True),
        Pin(59, is_analog=True),
        Pin(60, is_analog=True),
        Pin(61, is_analog=True),
        Pin(62, is_analog=True),
        Pin(63, is_analog=True),
        Pin(64, is_analog=True),
        Pin(65, is_analog=True),
        Pin(66, is_analog=True),
        Pin(67, is_analog=True),
        Pin(68, is_analog=True),
        Pin(69, is_analog=True),
    )
