# Changelog

<!--
This file is autogenerated.
Only edit this file directly to correct typos.
See CONTRIBUTING.md for instructions on how new entries get added.
-->

This document contains a history of significant changes which have been released for `mbed-tools`. Please note that
beta releases are not included in this history. For a full list of all releases, please see the
[PyPI Release History](https://pypi.org/project/mbed-tools/#history).

[//]: # (begin_release_notes)

7.26.0 (2021-06-25)
===================

Features
--------

- Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32620FTHR, MAX32625MBED, MAX32625PICO, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-G071RB, NUCLEO-G474RE, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NUCLEO-WL55JC, NUMAKER-M2354, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, PSoC 64 Secure Boot, Wi-Fi / BLE Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210625050116)


7.25.0 (2021-06-24)
===================

Features
--------

- Targets modified: NUCLEO-WB15CC, NUMAKER-M2354. (#20210624050112)


7.24.0 (2021-06-22)
===================

Features
--------

- Targets added: PSoC 64 Secure Boot, Wi-Fi / BLE Pioneer Kit.
  Targets removed: "PSoC 64 Secure Boot" Wi-Fi / Bluetooth Pioneer Kit. (#20210622050108)


7.23.0 (2021-06-17)
===================

Features
--------

- Targets modified: NUCLEO-G474RE. (#20210617050111)


7.22.0 (2021-06-16)
===================

Features
--------

- Targets modified: NUCLEO-G474RE. (#20210616050114)


7.21.0 (2021-06-12)
===================

Features
--------

- Targets added: Multitech Dragonfly L496VG. (#20210612050106)


7.20.0 (2021-06-08)
===================

Features
--------

- The `--flash` option of `mbed-tools compile` now automatically selects bin or hex image. The option `--hex-file` is removed. (#20210602164800)
- Targets modified: DISCO-WB5MMG. (#20210608050103)


7.19.1 (2021-06-05)
===================

Bugfixes
--------

- Properly handle --custom-targets-json in configure sub command (#286)
- Allow choosing output directory in configure sub command (#287)


7.19.0 (2021-06-04)
===================

Features
--------

- Add Cortex-A5 Support (#20210603213250)


7.18.0 (2021-05-28)
===================

Features
--------

- Targets modified: "PSoC 64 Secure Boot" Wi-Fi / Bluetooth Pioneer Kit, ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32625MBED, MAX32625PICO, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-G071RB, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NUCLEO-WL55JC, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210528050126)


7.17.0 (2021-05-27)
===================

Features
--------

- Targets modified: Advantech WISE-1510, Advantech WISE-1530, Advantech WISE-1570, Multitech Dragonfly, Multitech xDOT, Murata Type ABZ, NUCLEO-G474RE, u-blox NINA-B1, u-blox ODIN-W2. (#20210527050125)


Bugfixes
--------

- Fix issue with memory region overrides being ignored. (#20210524113403)
- Avoid searching config file paths twice when mbed-os-path is used and it is a subdirectory of the project path. (#20210524175020)


7.16.0 (2021-05-26)
===================

Features
--------

- Targets modified: MultiTech mDot. (#20210526050235)


7.15.0 (2021-05-15)
===================

Features
--------

- Targets modified: NUCLEO-WL55JC. (#20210515050137)


7.14.0 (2021-05-13)
===================

Features
--------

- Targets added: B-G473E-ZEST1S.
  Targets modified: NUCLEO-G071RB. (#20210513050112)


Misc
----

- #20210512103446


7.13.0 (2021-05-05)
===================

Features
--------

- Targets removed: MTB_RAK811.
  Targets modified: DISCO-WB5MMG. (#20210505050127)


7.12.0 (2021-04-28)
===================

Features
--------

- Targets modified: "PSoC 64 Secure Boot" Wi-Fi / Bluetooth Pioneer Kit, ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32625MBED, MAX32625PICO, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210428050110)


7.11.0 (2021-04-24)
===================

Features
--------

- Targets added: FRDM-K32L3A6. (#20210424050126)


7.10.1 (2021-04-23)
===================

Bugfixes
--------

- Add support for MBED_ROM_START, MBED_ROM_SIZE, MBED_RAM_START and MBED_RAM_SIZE in config system. (#222)


7.10.0 (2021-04-15)
===================

Features
--------

- Targets added: NUCLEO-U595ZJ-Q.
  Targets removed: NUCLEO-U595ZI-Q. (#20210415050117)


7.9.0 (2021-04-14)
==================

Features
--------

- Targets added: Atlas Product Development Kit, DISCO-C0116, DISCO-C0316, NUCLEO-C031C6, NUCLEO-H563ZI, NUCLEO-U595ZI-Q. (#20210414050122)


Bugfixes
--------

- Remove call to the deprecated `mbed_configure_app_target()` from `CMakeLists.txt` generated by `mbed-tools new`. (#268)


7.8.0 (2021-04-08)
==================

Features
--------

- Targets added: "PSoC 64 Secure Boot" Wi-Fi / Bluetooth Pioneer Kit.
  Targets removed: PSoC 64 Secure Boot WiFi/BLE Pioneer Kit. (#20210408050129)


7.7.0 (2021-04-02)
==================

Features
--------

- Add detection of devices connected with J-Link. (#20210330104425)
- Targets modified: MAX32625PICO. (#20210402050107)


Bugfixes
--------

- Unpin Click version to minimise the potential for dependency conflicts with other packages. (#245)
- Make details.txt parsing more lenient to avoid issues with various formats. (#258)


7.6.0 (2021-04-01)
==================

Features
--------

- Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32625MBED, MAX32625PICO, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, PSoC 64 Secure Boot WiFi/BLE Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210401050116)


Misc
----

- #20210315163230


7.5.1 (2021-03-26)
==================

Bugfixes
--------

- Add a CMake variable `MBED_OUTPUT_EXT` for the output image extension. (#216)


Misc
----

- #20210323151402


7.5.0 (2021-03-23)
==================

Features
--------

- Targets added: DISCO-WB5MMG.
  Targets removed: DISCO-WB5MM. (#20210323050222)


7.4.0 (2021-03-20)
==================

Features
--------

- Targets added: DISCO-WB5MM.
  Targets removed: STM32WB5MM-DK.
  Targets modified: NUMAKER-M2354. (#20210320050210)


7.3.3 (2021-03-13)
==================

Bugfixes
--------

- Improve error message when we fail to find a valid product code in a connected device's HTM file. (#229)


Misc
----

- #20210311162000, #20210312114544


7.3.2 (2021-03-12)
==================

Bugfixes
--------

- Windows USB identification refactored to remove Python version specific behaviour. (#202)


Misc
----

- #20210311092039


7.3.1 (2021-03-11)
==================

Bugfixes
--------

- Remove Mbed OS's Python dependencies as they are now optional within Mbed OS. (#171)


7.3.0 (2021-03-10)
==================

Features
--------

- Speed up obtaining library dependencies by obtaining only the requested library
  revision and no other revision. (#20210224162840)
- Targets removed: DEPRECATED!. (#20210310052057)


Bugfixes
--------

- Improve error messaging when unable to access the online database. (#20210304131741)


Misc
----

- #200, #20210308162221


7.2.1 (2021-03-04)
==================

Bugfixes
--------

- Define a board as unknown if it cannot be identified locally when unable to access the online database. (#201)
- Improve error messaging in targets module when an invalid override is detected. (#20210303115502)


7.2.0 (2021-03-03)
==================

Features
--------

- Add IDs to allow selection of a specific device when multiple of the same type are connected. (#181)
- Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32625MBED, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, PSoC 64 Secure Boot WiFi/BLE Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210303052642)


Bugfixes
--------

- Emit a warning instead of an error when the user attempts to override an undefined configuration parameter. (#20210301122753)
- Search mbed-os for config files when mbed-os-path is used and mbed-os is not a subdirectory of the project. (#20210302104001)


7.1.2 (2021-02-20)
==================

Bugfixes
--------

- Raise a nicer error from mbed-tools detect when running on an unrecognised OS. (#20210218112043)
- Fix for create a new Mbed OS project in current directory bug. (#20210218122316)


7.1.1 (2021-02-19)
==================

Bugfixes
--------

- Support use of user@host:directory syntax with the import subcommand. (#169)
- Clean up handling of config settings that have nested lists as values. (#20210217152408)


Misc
----

- #20210217153419


7.1.0 (2021-02-17)
==================

Features
--------

- Targets modified: NUCLEO-WL55JC, SDP-K1. (#20210217050139)


Bugfixes
--------

- Take namespaces into account when applying target overrides. (#191)


7.0.0 (2021-02-16)
==================

Major changes
-------------

- config: move mbed config cmake `mbed_config.cmake` file from root to build directory. (#20210210161209)


Features
--------

- Targets modified: MAX32625MBED, MAX32625PICO. (#20210216050133)


6.1.0 (2021-02-12)
==================

Features
--------

- Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32630FTHR, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, PSoC 64 Secure Boot WiFi/BLE Pioneer Kit, RHOMBIO L476DMW1K, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20210212050131)


Bugfixes
--------

- Support compilation of targets with sector attributes in targets.json. (#182)


6.0.0 (2021-02-10)
==================

Major changes
-------------

- The compile subcommand now requires both toolchain and mbed-target arguments. (#20210203124012)


Features
--------

- Builds are now separated by target, profile and toolchain, allowing use of different configurations without clearing previous builds. (#141)


5.5.0 (2021-02-06)
==================

Features
--------

- Support custom_targets.json. (#20201222090211)


5.4.0 (2021-02-03)
==================

Features
--------

- Targets removed: EFM32 Tiny Gecko 11, MCB4300.
  Targets modified: S5JS100. (#20210203050126)


5.3.0 (2021-01-30)
==================

Features
--------

- Targets added: arm_mps2_m55. (#20210130050107)


5.2.0 (2021-01-29)
==================

Features
--------

- Add Cortex-M55 target definitions (#20210127171548)
- Targets removed: ADV_WISE_1510, ADV_WISE_1530, ADV_WISE_1570, ADZS-U4050LF-EZKIT, Atmel ATSAMG55-XPRO, MTB_ACONNO_ACN52832, OKdo ODIN-W2, S3JT100, VNG VBLUNO51.
  Targets modified: MAX32625PICO. (#20210129050125)


Misc
----

- #20210127150731


5.1.0 (2021-01-27)
==================

Features
--------

- Targets modified: MAX32625MBED. (#20210127050123)


Misc
----

- #20210126131920


5.0.0 (2021-01-22)
==================

Major changes
-------------

- Compile: change command line option --build-type to --profile (#20210121143556)


Improved Documentation
----------------------

- Update the contributing guide to be more accessible and less scattered. (#144)


4.7.0 (2021-01-20)
==================

Features
--------

- Targets added: AdBun-M3HQA development board, SBK-M4KN development board. (#20210120050110)


Misc
----

- #20210119095356


4.6.1 (2021-01-16)
==================

Bugfixes
--------

- Rework config parsing code to enable easier bug fixing and maintainability. (#20201223142415)


Misc
----

- #20210113, #20210105113936


4.6.0 (2021-01-09)
==================

Features
--------

- Targets modified: SIDK S1SBP6A Bio-processor dev kit. (#20210109050122)


4.5.0 (2021-01-07)
==================

Features
--------

- Targets modified: SDP-K1. (#20210107050202)


4.4.0 (2020-12-22)
==================

Features
--------

- Add support for requires config option in mbed_app.json (#20201214165520)
- Targets modified: MAX32630FTHR. (#20201222050132)


4.3.0 (2020-12-19)
==================

Features
--------

- Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech xDot, NAMote72, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-LoRaD-M252, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, PSoC 64 Secure Boot WiFi/BLE Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, SIDK S1SBP6A Bio-processor dev kit, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20201219050142)


4.2.0 (2020-12-15)
==================

Features
--------

- Targets modified: B96B-F446VE, BBC micro:bit, CoreLink SSE-100 (IOT Subsystem for Cortex-M), DISCO-F334C8, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-L053C8, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, EA LPC4088 Display Module, EA LPC4088 QuickStart Board, EFM32 Giant Gecko, EFM32 Leopard Gecko, EFM32 Pearl Gecko, EFM32 USB-enabled Happy Gecko, EFM32 Wonder Gecko, EFM32 Zero Gecko, Ethernet IoT Starter Kit, FRDM-K20D50M, FRDM-K22F, FRDM-K64F, FRDM-KL05Z, FRDM-KL25Z, FRDM-KL27Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW24D512, FRDM-KW41Z, JKSoft Wallbot BLE, LPCXpresso11U68, LPCXpresso1549, LPCXpresso4337, LPCXpresso824-MAX, MultiTech Dragonfly, MultiTech mDot, NAMote72, NUCLEO-F030R8, NUCLEO-F031K6, NUCLEO-F042K6, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F302R8, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F334R8, NUCLEO-F401RE, NUCLEO-F410RB, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-L011K4, NUCLEO-L031K6, NUCLEO-L053R8, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NXP LPC800-MAX, Nordic nRF51-DK, Nordic nRF51-Dongle, Nordic nRF51822, NuMaker-PFM-M453, NuMaker-PFM-M487, RedBearLab BLE Nano, RedBearLab nRF51822, SDT64B, Seeed Arch BLE, Seeed Arch Link, Seeed Arch Max, Seeed Tiny BLE, Seeeduino-Arch, Seeeduino-Arch-Pro, Switch Science mbed LPC824, Switch Science mbed TY51822r3, Thunderboard Sense 2, WIZwiki-W7500, WIZwiki-W7500ECO, WIZwiki-W7500P, mbed HRM1017, mbed LPC1114FN28, mbed LPC11U24, mbed LPC1768, u-blox C027, u-blox EVK-NINA-B1. (#20201215050137)


Misc
----

- #20201208190734


4.1.1 (2020-12-13)
==================

Bugfixes
--------

- Emit more useful error messages if CMake or Ninja aren't found in PATH. (#20201210131204)


4.1.0 (2020-12-11)
==================

Features
--------

- Add --mbed-os-path option to `configure` and `build` (#20201203161101)
- Targets modified: ARM Beetle IoT Evaluation Platform, ARM MPS2+ FPGA Prototyping System, B96B-F446VE, BBC micro:bit, CoCo-ri-Co!, CoreLink SSE-100 (IOT Subsystem for Cortex-M), DISCO-F334C8, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-L053C8, DISCO-L072CZ-LRWAN1, DISCO-L475VG-IOT01A (B-L475E-IOT01A), DISCO-L476VG, DISCO-L496AG, Delta DFCM-NNN40 (EOL), EA LPC11U35 QuickStart Board, EA LPC4088 Display Module, EA LPC4088 QuickStart Board, EFM32 Giant Gecko, EFM32 Leopard Gecko, EFM32 Pearl Gecko, EFM32 USB-enabled Happy Gecko, EFM32 Wonder Gecko, EFM32 Zero Gecko, Ethernet IoT Starter Kit, FRDM-K20D50M, FRDM-K22F, FRDM-K64F, FRDM-KL05Z, FRDM-KL25Z, FRDM-KL27Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW24D512, FRDM-KW41Z, JKSoft Wallbot BLE, L-Tek FF1705, LPCXpresso11U68, LPCXpresso1549, LPCXpresso4337, LPCXpresso824-MAX, MAX32600MBED, MAXWSNENV, MtM+ MtConnect04S, MultiTech Dragonfly, MultiTech mDot, MultiTech mDot Box/EVB, NAMote72, NUCLEO-F030R8, NUCLEO-F031K6, NUCLEO-F042K6, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F302R8, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F334R8, NUCLEO-F401RE, NUCLEO-F410RB, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F429ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F767ZI, NUCLEO-L011K4, NUCLEO-L031K6, NUCLEO-L053R8, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NXP LPC800-MAX, Nordic nRF51-DK, Nordic nRF51-Dongle, Nordic nRF51822, Nordic nRF52-DK, NuMaker-PFM-M453, NuMaker-PFM-M487, RedBearLab BLE Nano, RedBearLab nRF51822, SDT64B, Seeed Arch BLE, Seeed Arch Link, Seeed Arch Max, Seeed Tiny BLE, Seeeduino-Arch, Seeeduino-Arch-Pro, Switch Science mbed LPC824, Switch Science mbed TY51822r3, Teensy 3.1, Thunderboard Sense 2, VK-RZ/A1H, WIZwiki-W7500, WIZwiki-W7500ECO, WIZwiki-W7500P, mbed HRM1017, mbed LPC1114FN28, mbed LPC11U24, mbed LPC1768, sakura.io Evaluation Board, u-blox C027, u-blox EVK-NINA-B1. (#20201211050132)


Misc
----

- #20201209160511


4.0.1 (2020-12-09)
==================

Bugfixes
--------

- Add c_lib and printf_lib to target config options (#20201130184919)
- Fix bug where we failed to handle config options that contain quotes (#125) (#20201201142709)


Misc
----

- #20201130143507, #20201202121845, #20201208124121


4.0.0 (2020-11-30)
==================

Major changes
-------------

- Rename checkout to deploy command to improve usability. (#202011091500)
- Rename init to new command to improve usability. (#202011101010)
- Rename clone to import command to improve usability. (#202011101200)
- Rename devices to detect command to improve usability. (#202011191400)
- Rename build to compile command to improve usability. (#202011191700)
- Remove the `libs` command and print a table of fetched dependencies after running `import` or `deploy. (#20201125120249)


Features
--------

- Save time by amking "deploy" only fetch a specific git reference when a .lib
  file contains a full git hash. (#202011271738)
- Implement sterm command. (#20201111104222)
- Add flash option to build command (#20201112095757)
- Add --sterm option to the compile command, allows users to open a serial terminal to the device after building and flashing their application. (#20201124142418)
- Targets added: SIDK S1SBP6A Bio-processor dev kit, ST Discovery STM32U599J.
  Targets removed: MAX32620MBED	, MAX32630 Micro Board Wearable low-powered Microcontroller Platform, ARM, MAX32630MBED.
  Targets modified: MAX32600MBED, NUMAKER-M2354. (#20201130181117)


Bugfixes
--------

- Use default branch from the remote repository, if no git hash in lib file. Fetch git repo before checkout when running `deploy` command. (#202011261100)
- Update CMakeLists template to reflect changes in Mbed OS CMake (#20201110140545)
- Fix the deploy command for projects containing multiple applications. (#20201119155311)


Improved Documentation
----------------------

- Move howto to mbed-os-5-docs (#202010301024)
- Update README.md and CONTRIBUTING.md with details on new release process. (#20201105153416)


Deprecations and Removals
-------------------------

- Remove unsupported documented feature called as Revision from deploy command. (#202011231100)


Misc
----

- #202011191602, #20201106115920, #20201106150801, #20201109115214, #20201127153832


3.5.0 (2020-11-06)
==================

Features
--------

- Add CMake variables for the supported application profiles to the generated CMake module (#20201023)
- Always regenerate build configuration when target and toolchain arguments are passed to the build subcommand. (#20201012141322)
- Targets added: Arm V2M-Musca-S1, B-L4S5I-IOT01A Discovery kit, DISCO-B-U585I-IOT02A, DISCO-L475VG-IOT01A (B-L475E-IOT01A), MCB4300, MIMXRT1024-EVK, MIMXRT1064-EVK, MIMXRT1180-EVK, NuMaker-LoRaD-M252, PSoC 64 Secure Boot WiFi/BLE Pioneer Kit.
  Targets removed: B-L4S5I-IOT01A, DISCO-L475VG-IOT01A, IoT-Board, MTB_LAIRD_BL600, MTB_LAIRD_BL654, MTB_MTS_DRAGONFLY, MTB_MTS_XDOT, MTB_MURATA_ABZ, MTB_MURATA_WSM_BL241, MTB_MXCHIP_EMW3166, MTB_STM32_F439, MTB_STM_L475, MTB_STM_S2LP, MTB_UBLOX_NINA_B1, MTB_UBLOX_ODIN_W2, Mbed WiFi BLE, NUMAKER-IOT-M252, Reserved-0450-0490-for-MODULE, Rohm_RoKiX, S1SBP6A, Seeed Wio W600.
  Targets modified: ARM Cortex-M3 DesignStart, AdBun-M46B, AdBun-M4G9, Agora Product Development Kit, DISCO-F334C8, DISCO-F413ZH, DISCO-F429ZI, DISCO-F469NI, DISCO-F746NG, DISCO-F769NI, DISCO-H747I, DISCO-L053C8, DISCO-L072CZ-LRWAN1, DISCO-L476VG, DISCO-L496AG, DISCO-L4R9I, DISCO-L562QE (STM32L562E-DK), EFM32 Giant Gecko, EV-COG-AD3029LZ, EV-COG-AD4050LZ, FRDM-K22F, FRDM-K64F, FRDM-K66F, FRDM-K82F, FRDM-KL25Z, FRDM-KL43Z, FRDM-KL46Z, FRDM-KW41Z, GD32-F307VG, GD32-F450ZI, GR-LYCHEE, GR-MANGO, GR-PEACH, Hexiwear, IMXRT1050-EVKB, L-Tek FF-LPC546XX, MAX32600MBED, MultiTech Dragonfly, MultiTech Dragonfly Nano, MultiTech mDot, MultiTech mDot Box/EVB, MultiTech xDot, NAMote72, NUCLEO-F031K6, NUCLEO-F042K6, NUCLEO-F070RB, NUCLEO-F072RB, NUCLEO-F091RC, NUCLEO-F103RB, NUCLEO-F207ZG, NUCLEO-F303K8, NUCLEO-F303RE, NUCLEO-F303ZE, NUCLEO-F334R8, NUCLEO-F401RE, NUCLEO-F411RE, NUCLEO-F412ZG, NUCLEO-F413ZH, NUCLEO-F429ZI, NUCLEO-F439ZI, NUCLEO-F446RE, NUCLEO-F446ZE, NUCLEO-F746ZG, NUCLEO-F756ZG, NUCLEO-F767ZI, NUCLEO-G031K8, NUCLEO-G474RE, NUCLEO-H743ZI2, NUCLEO-L073RZ, NUCLEO-L152RE, NUCLEO-L432KC, NUCLEO-L433RC-P, NUCLEO-L476RG, NUCLEO-L486RG, NUCLEO-L496ZG, NUCLEO-L4R5ZI, NUCLEO-L4R5ZI-P, NUCLEO-WB55RG, NXP LPCXpresso54114, NXP LPCXpresso54608, NXP LPCXpresso54628, NuMaker-IoT-M263A, NuMaker-IoT-M487, NuMaker-PFM-M453, NuMaker-PFM-M487, NuMaker-PFM-NANO130, NuMaker-PFM-NUC472, PSoC 6 BLE Pioneer Kit, PSoC 6 Wi-Fi BT Prototyping Kit, PSoC 6 WiFi-BT Pioneer Kit, RHOMBIO L476DMW1K, SDP-K1, SDT32620B, SDT32625B, SDT52832B, SDT64B, Seeed Arch Max, Seeed Wio 3G, Seeed Wio LTE M1/NB1(BG96), Seeeduino-Arch-Pro, Thunderboard Sense 2, Uhuru RAVEN, mbed LPC1114FN28, mbed LPC1768. (#20201106090030, #20201106090321)


Bugfixes
--------

- Do not check for mbed-os.lib in MbedProgram::from_url as it was making clone fail on examples containing multiple programs. (#62)
- Fix https to ssh redirection (#66)


Improved Documentation
----------------------

- Document build command (#202010131300)
- Document libs command (#202010211355)
- Fix formatting issue in docs (#202010261000)
- Update documentation for Mbed CLI 2 (#202010281400)


Misc
----

- #202010261100, #202011041130, #20201016135546, #20201021132447


"3.4.0" (2020-10-12)
====================

Features
--------

- Add build command porcelain to build an Mbed project using CMake and Ninja. (#20200929104817)
- Replace assert-news with towncrier.check (#20201001170005)


Improved Documentation
----------------------

- Advise on using Tox rather than pipenv virtual environment (#202010091700)


Deprecations and Removals
-------------------------

- Remove consistency report checks (#202010091202)
- Remove install-development-dependencies.yml (#202010091203)
- Remove Pipfile (#202010091204)
- Remove pipenv from generate-target-database.yaml (#2020100812003)


Misc
----

- #202009291300, #202010061300, #202010091200, #202010091201, #2020100812000, #2020100812001, #2020100812002, #2020100812004, #20200925151500, #20200929160957


"3.3.0" (2020-09-17)
====================

Features
--------

- Add CMake variables for the selected printf and C library to the generated CMake module (#20200915)
- Add travis config file (#20200814183927)


Improved Documentation
----------------------

- Add create project, config and build instructions. (#202008211200)
- Update create project, example application and project environment instructions. (#202008251200)
- Add logging info. (#202008261300)


Misc
----

- #20200820131700, #20200820132210, #20200821142453


"3.2.2" (2020-08-19)
====================

Bugfixes
--------

- Remove MBED_BUILD_TIMESTAMP config option (#20200819144454)


Misc
----

- #20200817142518


"3.2.1" (2020-08-17)
====================

Bugfixes
--------

- Removing unused MBED_PROFILE, please use CMAKE_BUILD_TYPE to select a profile. (#20200813)
- Ensure program path is always made absolute on Windows. (#20200816123120)


"3.2.0" (2020-08-12)
====================

Features
--------

- Generate project startup files from init command (#20200810123455)


Bugfixes
--------

- Return an exit code of 1 when a ToolsError is raised (#20200729210710)
- Remove output path and use program root for configure command output (#20200805143228)
- Remove mbed-tools/project's dependency on the legacy .mbed file (#20200805210417)
- Process labels gathered from mbed_lib and mbed_app config files (#20200811095825)


Improved Documentation
----------------------

- add user docs (#20200730153335)
- Add install instructions and prerequisites (#20200811162038)


Misc
----

- #20200727201841, #20200729200627, #20200730145703, #20200805134310, #20200805160557


"3.1.2" (2020-07-29)
====================

Bugfixes
--------

- Remove gen_config interface library target from cmake template (#20200727143830)


"3.1.1" (2020-07-27)
====================

Bugfixes
--------

- Add manifest.in rule to upload all data files under the src dorectory (#20200727151049)


"3.1.0" (2020-07-27)
====================

Features
--------

- Create single package layout for mbed-tools (#20200722134138)


Improved Documentation
----------------------

- Add ADR for removing mbed_config.h (#20200723142705)


"3.0.1" (2020-07-20)
====================

Bugfixes
--------

- Pin mbed-build to ~1.2 (#20200720152641)


"3.0.0" (2020-07-20)
====================

Major changes
-------------

- Rename export to configure. (#20200717104411)


Features
--------

- Rename export-keys command to export (#20200701)


Bugfixes
--------

- Declare MIT license for zipp dependency (#20200701)


Improved Documentation
----------------------

- Add the minimal version requirement on pipenv (#20200709222031)


Misc
----

- #20200715101809


"2.1.0" (2020-04-30)
====================

Features
--------

- Add build command. (#20200430)


"2.0.0" (2020-04-29)
====================

Major changes
-------------

- Change export command name to be more accurate for the time being. (#20200416)


Features
--------

- Catch and log ToolsErrors in the CLI (#20200318)
- Use new context manager for handling tools errors and improved user friendly message about increasing verbosity (#20200403)
- Add export command to tools (#20200407)
- Added --version option to return versions of all Mbed packages (#20200422)
- Support added for Python 3.8 (#20200423)
- Add mbed-project commands (#20200427)
- Add conig command. (#20200428)
- Add config sub command (#2020031801)


Bugfixes
--------

- Sync with internal cookiecutter template (#20200317)
- Fixed spelling error (#20200408)
- Checked 3rd-party licences. (#20200427)


Improved Documentation
----------------------

- Added license headers for SPDX compliance. (#20200402)


Misc
----

- #20200316, #20200402, #20200420, #20200423, #20200427, #20200428


"1.0.0" (2020-03-06)
====================

Major changes
-------------

- Artificial release bump because of old mbed-tools (#20200207)


Features
--------

- Integrate mbed-devices (#20200207)


Misc
----

- #20200210
