# Generated by Django 3.2.13 on 2022-07-22 16:31

from django.db import migrations, models


def data_bytes_to_string_up(apps, schema_editor):
    CollectionVersionSignature = apps.get_model("ansible", "CollectionVersionSignature")
    signature_batch = []
    for signature in CollectionVersionSignature.objects.all():
        signature.new_data = bytes(signature.data).decode()
        signature_batch.append(signature)
        if len(signature_batch) >= 1000:
            CollectionVersionSignature.objects.bulk_update(signature_batch, ["new_data"])
            signature_batch.clear()
    CollectionVersionSignature.objects.bulk_update(signature_batch, ["new_data"])


def data_bytes_to_string_down(apps, schema_editor):
    CollectionVersionSignature = apps.get_model("ansible", "CollectionVersionSignature")
    signature_batch = []
    for signature in CollectionVersionSignature.objects.all():
        signature.data = signature.new_data.encode()
        signature_batch.append(signature)
        if len(signature_batch) >= 1000:
            CollectionVersionSignature.objects.bulk_update(signature_batch, ["data"])
            signature_batch.clear()
    CollectionVersionSignature.objects.bulk_update(signature_batch, ["data"])


class Migration(migrations.Migration):

    dependencies = [
        ('ansible', '0042_ansiblerepository_gpgkey'),
    ]

    operations = [
        migrations.AlterField(
            model_name='collectionversionsignature',
            name='data',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='collectionversionsignature',
            name='new_data',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
        migrations.RunPython(
            code=data_bytes_to_string_up,
            reverse_code=data_bytes_to_string_down,
        ),
        migrations.RemoveField(
            model_name='collectionversionsignature',
            name='data',
        ),
        migrations.RenameField(
            model_name='collectionversionsignature',
            old_name='new_data',
            new_name='data',
        ),
    ]
