"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StageBase = exports.ApiBase = void 0;
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const integration_cache_1 = require("../private/integration-cache");
const api_mapping_1 = require("./api-mapping");
/**
 * Base class representing an API
 * @internal
 */
class ApiBase extends aws_cdk_lib_1.Resource {
    constructor() {
        super(...arguments);
        /**
         * @internal
         */
        this._integrationCache = new integration_cache_1.IntegrationCache();
    }
    /**
     * (experimental) Return the given named metric for this Api Gateway.
     *
     * @experimental
     */
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/ApiGateway',
            metricName,
            dimensionsMap: { ApiId: this.apiId },
            ...props,
        }).attachTo(this);
    }
}
exports.ApiBase = ApiBase;
/**
 * Base class representing a Stage
 * @internal
 */
class StageBase extends aws_cdk_lib_1.Resource {
    /**
     * @internal
     */
    _addDomainMapping(domainMapping) {
        if (this._apiMapping) {
            throw new Error('Only one ApiMapping allowed per Stage');
        }
        this._apiMapping = new api_mapping_1.ApiMapping(this, `${domainMapping.domainName}${domainMapping.mappingKey}`, {
            api: this.baseApi,
            domainName: domainMapping.domainName,
            stage: this,
            apiMappingKey: domainMapping.mappingKey,
        });
        // ensure the dependency
        this.node.addDependency(domainMapping.domainName);
    }
    /**
     * (experimental) Return the given named metric for this HTTP Api Gateway Stage.
     *
     * @experimental
     */
    metric(metricName, props) {
        return this.baseApi.metric(metricName, props).with({
            dimensionsMap: { ApiId: this.baseApi.apiId, Stage: this.stageName },
        }).attachTo(this);
    }
}
exports.StageBase = StageBase;
//# sourceMappingURL=data:application/json;base64,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