# coding: utf-8

from __future__ import absolute_import, unicode_literals

from django.db import models
from django.utils import six


class NonAsciiRepr(object):
    def __repr__(self):
        return "nôt åscíì" if six.PY3 else "nôt åscíì".encode("utf-8")


class Binary(models.Model):
    field = models.BinaryField()


try:
    from django.contrib.postgres.fields import JSONField
except ImportError:  # psycopg2 not installed
    JSONField = None


if JSONField:

    class PostgresJSON(models.Model):
        field = JSONField()
