import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface IManagedInstanceRoleProps {
    /**
     * The managed policies to apply to the role in addition to the default policies.
     *
     * @stability stable
     */
    managedPolicies?: iam.ManagedPolicy[];
    /**
     * Should the role include directory service access with SSM.
     *
     * @stability stable
     */
    domainJoinEnabled?: boolean;
    /**
     * Should the role include SSM management.
     *
     * By default if domainJoinEnabled is true then this role is always included.
     *
     * @stability stable
     */
    ssmManagementEnabled?: boolean;
}
/**
 * @stability stable
 */
export declare class ManagedInstanceRole extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly instanceProfile: iam.CfnInstanceProfile;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: IManagedInstanceRoleProps);
}
