# Generated by Django 3.2 on 2021-06-16 18:40

from django.db import migrations


IMPORT_SQL = '''
insert into wcd_geo_db_divisioncode(code, value, entity_id)
select
    e.json_code_code as code,
    e.codes ->> e.json_code_code as value,
    e.id as entity_id
from (
select
    jsonb_object_keys(t.codes) as json_code_code, t.*
from wcd_geo_db_division t
) e;
'''
EXPORT_SQL = '''
update wcd_geo_db_division
set codes = e.codes
from (
    select jsonb_object_agg(t.code, t.value) as codes, t.entity_id as id
    from wcd_geo_db_divisioncode t group by t.entity_id order by t.entity_id
) as e
where wcd_geo_db_division.id = e.id;
'''

class Migration(migrations.Migration):

    dependencies = [
        ('wcd_geo_db', '0009_auto_20210616_1837'),
    ]

    operations = [
        # Moves data from `codes` json to a specialized table and back.
        migrations.RunSQL(IMPORT_SQL, EXPORT_SQL),
        migrations.RunSQL('select 1;', 'delete from wcd_geo_db_divisioncode;'),
    ]
