import { Metric, MetricOptions } from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { StageOptions, IStage, StageAttributes } from '../common';
import { IApi } from '../common/api';
import { StageBase } from '../common/base';
import { IHttpApi } from './api';
/**
 * (experimental) Represents the HttpStage.
 *
 * @experimental
 */
export interface IHttpStage extends IStage {
    /**
     * (experimental) The API this stage is associated to.
     *
     * @experimental
     */
    readonly api: IHttpApi;
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricClientError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricServerError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricDataProcessed(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @default - SampleCount over 5 minutes
     * @experimental
     */
    metricCount(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @default - no statistic
     * @experimental
     */
    metricIntegrationLatency(props?: MetricOptions): Metric;
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @default - no statistic
     * @experimental
     */
    metricLatency(props?: MetricOptions): Metric;
}
/**
 * (experimental) The options to create a new Stage for an HTTP API.
 *
 * @experimental
 */
export interface HttpStageOptions extends StageOptions {
    /**
     * (experimental) The name of the stage.
     *
     * See `StageName` class for more details.
     *
     * @default '$default' the default stage of the API. This stage will have the URL at the root of the API endpoint.
     * @experimental
     */
    readonly stageName?: string;
}
/**
 * (experimental) Properties to initialize an instance of `HttpStage`.
 *
 * @experimental
 */
export interface HttpStageProps extends HttpStageOptions {
    /**
     * (experimental) The HTTP API to which this stage is associated.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
}
/**
 * (experimental) The attributes used to import existing HttpStage.
 *
 * @experimental
 */
export interface HttpStageAttributes extends StageAttributes {
    /**
     * (experimental) The API to which this stage is associated.
     *
     * @experimental
     */
    readonly api: IHttpApi;
}
declare abstract class HttpStageBase extends StageBase implements IHttpStage {
    abstract readonly api: IHttpApi;
    /**
     * (experimental) Metric for the number of client-side errors captured in a given period.
     *
     * @experimental
     */
    metricClientError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the number of server-side errors captured in a given period.
     *
     * @experimental
     */
    metricServerError(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the amount of data processed in bytes.
     *
     * @experimental
     */
    metricDataProcessed(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the total number API requests in a given period.
     *
     * @experimental
     */
    metricCount(props?: MetricOptions): Metric;
    /**
     * (experimental) Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     *
     * @experimental
     */
    metricIntegrationLatency(props?: MetricOptions): Metric;
    /**
     * (experimental) The time between when API Gateway receives a request from a client and when it returns a response to the client.
     *
     * The latency includes the integration latency and other API Gateway overhead.
     *
     * @experimental
     */
    metricLatency(props?: MetricOptions): Metric;
}
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
export declare class HttpStage extends HttpStageBase {
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromHttpStageAttributes(scope: Construct, id: string, attrs: HttpStageAttributes): IHttpStage;
    /**
     * @experimental
     */
    protected readonly baseApi: IApi;
    /**
     * (experimental) The name of the stage;
     *
     * its primary identifier.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * (experimental) The API this stage is associated to.
     *
     * @experimental
     */
    readonly api: IHttpApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpStageProps);
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    get url(): string;
    /**
     * (experimental) The custom domain URL to this stage.
     *
     * @experimental
     */
    get domainUrl(): string;
}
export {};
