# AUTOGENERATED! DO NOT EDIT! File to edit: 01_generators.ipynb (unless otherwise specified).

__all__ = ['generate_settings', 'generate_ci', 'generate_doc_foundations', 'generate_setup']

# Cell
from fastcore.xtras import Path
import requests

# Cell
def generate_settings():
    """
    Guide the user for generating a proper `settings.ini` if one does not already exist in the directory
    """
    if Path('settings.ini').exists():
        print("settings.ini already exists, going off existing version")
        return
    print("No settings.ini exists, let's make one:")
    f = open("settings.ini", 'w')
    user_inp = {}

    user_inp['[DEFAULT]\nhost'] = 'github\n'
    user_inp['lib_name'] = input("Please enter the name of your library: ")
    _enterprise = int(input("Is this an Enterprise Git? (0 or 1): "))

    if _enterprise:
        user_inp['repo_name'] = input("Please enter the repo name: ")
        user_inp['company_name'] = input("Please enter the company name: ")

    user_inp['user'] = input("Please enter your git username: ")
    user_inp['description'] = input("Please enter a description of the project: ")
    user_inp['keywords'] = input("Please enter some keywords for your project seperated by a space: ")
    user_inp['author'] = input("Please enter all main authors names (seperate names with a space): ")
    user_inp['author_email'] = input("Please enter a main email contact for the project: ")
    user_inp['copyright'] = input("Please enter a Copyright (such as company name or your name): ")
    user_inp['branch'] = input("Please enter the head branch of this project (such as master/main): ")
    user_inp['version'] = input("Please enter the current version of this project: ")
    user_inp['min_python'] = input("Please enter the minimum required Python for this project (such as 3.6): ")
    user_inp['audience'] = 'Developers'; user_inp['language'] = 'English'

    for k, v in user_inp.items(): f.write(f'{k} = {v}\n')

    nbs = input("Please enter where you would like your notebooks stored? (Usually `nbs` or `.`): ")

    f.write('# Set to True if you want to create a more fancy sidebar.json than the default\ncustom_sidebar = False\n')
    f.write('# Add licenses and see current list in `setup.py`\nlicense = apache2\n')
    f.write('# From 1-7: Planning Pre-Alpha Alpha Beta Production Mature Inactive\nstatus = 2\n')
    f.write('''
# Optional. Same format as setuptools requirements
# requirements =
# Optional. Same format as setuptools console_scripts
# console_scripts =
# Optional. Same format as setuptools dependency-links
# dep_links = ''')
    f.write('''
###
# You probably won't need to change anything under here,
#   unless you have some special requirements
###

# Change to, e.g. "nbs", to put your notebooks in nbs dir instead of repo root
''')
    f.write(f'nbs_path = {nbs}\n')
    f.write('doc_path = docs\n')
    f.write('# Whether to look for library notebooks recursively in the `nbs_path` dir\nrecursive = False\n')
    f.write("\n\n\n# Anything shown as '%(...)s' is substituted with that setting automatically")

    f.write('doc_host = https://%(user)s.github.io\n') if not _enterprise else f.write('doc_host = https://pages.github.%(company_name)s.com\n')
    f.write('doc_baseurl = /%(lib_name)s/\n') if not _enterprise else f.write('doc_baseurl  = /%(repo_name)s/%(lib_name)s/\n')
    if not _enterprise: f.write('git_url = https://github.com/%(user)s/%(lib_name)s/tree/%(branch)s/\n')
    else: f.write('git_url  = https://github.%(company_name)s.com/%(repo_name)s/%(lib_name)s/tree/%(branch)s/\n')
    f.write('\n\n\nlib_path = %(lib_name)s\ntitle = %(lib_name)s\n')
    f.write('''
#Optional advanced parameters
#Monospace docstings: adds <pre> tags around the doc strings, preserving newlines/indentation.
#monospace_docstrings = False
#Test flags: introduce here the test flags you want to use separated by |
#tst_flags =
#Custom sidebar: customize sidebar.json yourself for advanced sidebars (False/True)
#custom_sidebar =
#Cell spacing: if you want cell blocks in code separated by more than one new line
#cell_spacing =
#Custom jekyll styles: if you want more jekyll styles than tip/important/warning, set them here
#jekyll_styles = note,warning,tip,important
    ''')
    print("If there are any necissary requirements for the project, please add them to the requirements section")
    print("If there should be any test flags, please add them to the tst_flags section")
    print("settings.ini successfully generated")

# Cell
def generate_ci():
    """
    Generates a Github action for running nbdev tests
    """
    path = Path('.github/workflows')
    if not path.exists(): path.mkdir(parents=True)
    if (path/'nbdev.yml').exists():
        print("nbdev.yml already exists, please modify the existing version")
        return

    f = open(path/'nbdev.yml', 'w')
    f.write('''
name: nbdev CI
on: [push, pull_request]
jobs:
  build:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v1
    - uses: actions/setup-python@v1
      with:
        python-version: '3.6'
        architecture: 'x64'
    - name: Install the library
      run: |
        pip install nbdev jupyter
        pip install -e .
    - name: Read all notebooks
      run: |
        nbdev_read_nbs
    - name: Check if all notebooks are cleaned
      run: |
        echo "Check we are starting with clean git checkout"
        if [ -n "$(git status -uno -s)" ]; then echo "git status is not clean"; false; fi
        echo "Trying to strip out notebooks"
        nbdev_clean_nbs
        echo "Check that strip out was unnecessary"
        git status -s # display the status to see which nbs need cleaning up
        if [ -n "$(git status -uno -s)" ]; then echo -e "!!! Detected unstripped out notebooks\n!!!Remember to run nbdev_install_git_hooks"; false; fi
    - name: Check if there is no diff library/notebooks
      run: |
        if [ -n "$(nbdev_diff_nbs)" ]; then echo -e "!!! Detected difference between the notebooks and the library"; false; fi
    - name: Run tests
      run: |
        nbdev_test_nbs''')

# Cell
def generate_doc_foundations():
    """
    Grabs the needed files for documentation from [nbdev_template](https://github.com/fastai/nbdev_template)
    """
    _base_url = 'https://raw.githubusercontent.com/fastai/nbdev/master/docs'
    _urls = {
        'Gemfile':f'{_base_url}/Gemfile',
        'Gemfile.lock': f'{_base_url}/Gemfile.lock',
        'feed.xml': f'{_base_url}/feed.xml',
        'sitemap.xml': f'{_base_url}/sitemap.xml',
        '.gitignore': f'{_base_url}/.gitignore' # Specific gitignore
    }
    print("Initializing documentation foundation...")
    base_path = Path('docs')
    base_path.mkdir(exist_ok=True)
    for fname, url in _urls.items():
        r = requests.get(url)
        with open(base_path/fname, 'w') as f:
            f.write(r.text)

# Cell
def generate_setup():
    """
    Grabs the original setup.py file from [nbdev_template](https://github.com/fastai/nbdev_template)
    """
    r = requests.get('https://raw.githubusercontent.com/fastai/nbdev/master/setup.py')
    with open('setup.py', 'w') as f: f.write(r.text)