import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 */
export interface CfnCanaryProps {
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     * @external
     */
    readonly artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     * @external
     */
    readonly code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     * @external
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     * @external
     */
    readonly runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     * @external
     */
    readonly schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     * @external
     */
    readonly startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     * @external
     */
    readonly failureRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.RunConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     * @external
     */
    readonly runConfig?: CfnCanary.RunConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     * @external
     */
    readonly successRetentionPeriod?: number;
    /**
     * `AWS::Synthetics::Canary.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Synthetics::Canary.VPCConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnCanary.VPCConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 */
export declare class CfnCanary extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Synthetics::Canary";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCanary;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute State
     */
    readonly attrState: string;
    /**
     * `AWS::Synthetics::Canary.ArtifactS3Location`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-artifacts3location
     * @external
     */
    artifactS3Location: string;
    /**
     * `AWS::Synthetics::Canary.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-code
     * @external
     */
    code: CfnCanary.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-executionrolearn
     * @external
     */
    executionRoleArn: string;
    /**
     * `AWS::Synthetics::Canary.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-name
     * @external
     */
    name: string;
    /**
     * `AWS::Synthetics::Canary.RuntimeVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runtimeversion
     * @external
     */
    runtimeVersion: string;
    /**
     * `AWS::Synthetics::Canary.Schedule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-schedule
     * @external
     */
    schedule: CfnCanary.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.StartCanaryAfterCreation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-startcanaryaftercreation
     * @external
     */
    startCanaryAfterCreation: boolean | cdk.IResolvable;
    /**
     * `AWS::Synthetics::Canary.FailureRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-failureretentionperiod
     * @external
     */
    failureRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.RunConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-runconfig
     * @external
     */
    runConfig: CfnCanary.RunConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Synthetics::Canary.SuccessRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-successretentionperiod
     * @external
     */
    successRetentionPeriod: number | undefined;
    /**
     * `AWS::Synthetics::Canary.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Synthetics::Canary.VPCConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html#cfn-synthetics-canary-vpcconfig
     * @external
     */
    vpcConfig: CfnCanary.VPCConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Synthetics::Canary`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCanaryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 */
export declare namespace CfnCanary {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html
     * @external
     */
    interface CodeProperty {
        /**
         * `CfnCanary.CodeProperty.Handler`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-handler
         * @external
         */
        readonly handler?: string;
        /**
         * `CfnCanary.CodeProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3bucket
         * @external
         */
        readonly s3Bucket?: string;
        /**
         * `CfnCanary.CodeProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3key
         * @external
         */
        readonly s3Key?: string;
        /**
         * `CfnCanary.CodeProperty.S3ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-s3objectversion
         * @external
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnCanary.CodeProperty.Script`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-code.html#cfn-synthetics-canary-code-script
         * @external
         */
        readonly script?: string;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 */
export declare namespace CfnCanary {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html
     * @external
     */
    interface RunConfigProperty {
        /**
         * `CfnCanary.RunConfigProperty.ActiveTracing`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-activetracing
         * @external
         */
        readonly activeTracing?: boolean | cdk.IResolvable;
        /**
         * `CfnCanary.RunConfigProperty.MemoryInMB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-memoryinmb
         * @external
         */
        readonly memoryInMb?: number;
        /**
         * `CfnCanary.RunConfigProperty.TimeoutInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-runconfig.html#cfn-synthetics-canary-runconfig-timeoutinseconds
         * @external
         */
        readonly timeoutInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 */
export declare namespace CfnCanary {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html
     * @external
     */
    interface ScheduleProperty {
        /**
         * `CfnCanary.ScheduleProperty.DurationInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-durationinseconds
         * @external
         */
        readonly durationInSeconds?: string;
        /**
         * `CfnCanary.ScheduleProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-schedule.html#cfn-synthetics-canary-schedule-expression
         * @external
         */
        readonly expression: string;
    }
}
/**
 * A CloudFormation `AWS::Synthetics::Canary`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-synthetics-canary.html
 * @external
 * @cloudformationResource AWS::Synthetics::Canary
 */
export declare namespace CfnCanary {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html
     * @external
     */
    interface VPCConfigProperty {
        /**
         * `CfnCanary.VPCConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-subnetids
         * @external
         */
        readonly subnetIds: string[];
        /**
         * `CfnCanary.VPCConfigProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-synthetics-canary-vpcconfig.html#cfn-synthetics-canary-vpcconfig-vpcid
         * @external
         */
        readonly vpcId?: string;
    }
}
